package com.chenyang.druid.sql.dialect.postgresql.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.postgresql.ast.PGSQLObject;
import com.chenyang.druid.sql.dialect.postgresql.ast.PGSQLObjectImpl;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class PGAlterTableDropConstraint extends PGSQLObjectImpl implements SQLAlterTableItem, PGSQLObject {
   private SQLExpr constraint;
   private boolean ifExists;
   private DorpType type;

   public SQLExpr getConstraint() {
      return this.constraint;
   }

   public void setConstraint(SQLExpr constraint) {
      this.constraint = constraint;
      constraint.setParent(this);
   }

   public boolean isIfExists() {
      return this.ifExists;
   }

   public void setIfExists(boolean ifExists) {
      this.ifExists = ifExists;
   }

   public DorpType getType() {
      return this.type;
   }

   public void setType(DorpType type) {
      this.type = type;
   }

   public void accept0(SQLASTVisitor visitor) {
      this.accept0((PGASTVisitor)visitor);
   }

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.constraint.accept(visitor);
      }

      visitor.endVisit(this);
   }

   public PGAlterTableDropConstraint clone() {
      PGAlterTableDropConstraint c = new PGAlterTableDropConstraint();
      c.setConstraint(this.constraint.clone());
      c.type = this.type;
      c.ifExists = this.ifExists;
      return c;
   }

   public static enum DorpType {
      restrict,
      cascade;
   }
}
