package com.chenyang.druid.sql.dialect.postgresql.ast.stmt.alterTable;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableItem;
import com.chenyang.druid.sql.dialect.postgresql.ast.PGSQLObjectImpl;
import com.chenyang.druid.sql.dialect.postgresql.visitor.PGASTVisitor;

public class PGAlterTableSetSchema extends PGSQLObjectImpl implements SQLAlterTableItem {
   private SQLExpr schema;

   public void accept0(PGASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.schema);
      }

      visitor.endVisit(this);
   }

   public SQLExpr getSchema() {
      return this.schema;
   }

   public void setSchema(SQLExpr schema) {
      schema.setParent(this);
      this.schema = schema;
   }

   public PGAlterTableSetSchema clone() {
      PGAlterTableSetSchema c = new PGAlterTableSetSchema();
      c.setSchema(this.schema.clone());
      return c;
   }
}
