package com.chenyang.druid.sql.dialect.presto.parser;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.parser.Lexer;
import com.chenyang.druid.sql.parser.SQLExprParser;
import com.chenyang.druid.sql.parser.SQLParserFeature;

public class PrestoExprParser extends SQLExprParser {
   public PrestoExprParser(String sql, SQLParserFeature... features) {
      this(new PrestoLexer(sql, features));
      this.lexer.nextToken();
   }

   public PrestoExprParser(Lexer lexer) {
      super(lexer);
      this.dbType = DbType.presto;
   }
}
