package com.chenyang.druid.sql.dialect.spark.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.dialect.spark.ast.SparkSqlExprImpl;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.ArrayList;
import java.util.List;
import util.sqlparse.visitor.common.Objects;

public class SparkColumnDef extends SparkSqlExprImpl {
   private SQLExpr column;
   private SQLExpr type;

   public SparkColumnDef() {
   }

   public SparkColumnDef(SQLExpr column, SQLExpr type) {
      this.column = column;
      this.type = type;
   }

   public List<SQLObject> getChildren() {
      List<SQLObject> children = new ArrayList();
      children.add(this.column);
      if (this.type != null) {
         children.add(this.type);
      }

      return children;
   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.column);
         this.acceptChild(v, this.type);
      }

   }

   public SQLExpr getColumn() {
      return this.column;
   }

   public void setColumn(SQLExpr column) {
      this.column = column;
   }

   public SQLExpr getType() {
      return this.type;
   }

   public void setType(SQLExpr type) {
      this.type = type;
   }

   public boolean equals(Object o) {
      if (this == o) {
         return true;
      } else if (o != null && this.getClass() == o.getClass()) {
         SparkColumnDef that = (SparkColumnDef)o;
         return Objects.equals(this.column, that.column) && Objects.equals(this.type, that.type);
      } else {
         return false;
      }
   }

   public int hashCode() {
      return Objects.hash(this.column, this.type);
   }

   public SparkColumnDef clone() {
      SparkColumnDef e = new SparkColumnDef();
      e.column = this.column.clone();
      if (this.type != null) {
         e.type = this.type.clone();
      }

      return e;
   }
}
