package com.chenyang.druid.sql.dialect.spark.ast.expr;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.dialect.spark.ast.SparkSqlObjectImpl;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import java.util.ArrayList;
import java.util.List;

public class SparkSelectPivot extends SparkSelectPivotBase {
   private boolean xml;
   private final List<Item> items = new ArrayList();
   private final List<SQLExpr> pivotFor = new ArrayList();
   private final List<Item> pivotIn = new ArrayList();

   public void accept0(SparkVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.items);
         this.acceptChild(visitor, this.pivotFor);
         this.acceptChild(visitor, this.pivotIn);
      }

      visitor.endVisit(this);
   }

   public List<Item> getPivotIn() {
      return this.pivotIn;
   }

   public List<SQLExpr> getPivotFor() {
      return this.pivotFor;
   }

   public boolean isXml() {
      return this.xml;
   }

   public List<Item> getItems() {
      return this.items;
   }

   public void addItem(Item item) {
      if (item != null) {
         item.setParent(this);
      }

      this.items.add(item);
   }

   public void setXml(boolean xml) {
      this.xml = xml;
   }

   public SparkSelectPivot clone() {
      SparkSelectPivot x = new SparkSelectPivot();
      x.setXml(this.xml);

      for(Item e : this.items) {
         Item e2 = e.clone();
         e2.setParent(x);
         x.getItems().add(e2);
      }

      for(SQLExpr e : this.pivotFor) {
         SQLExpr e2 = e.clone();
         e2.setParent(x);
         x.getPivotFor().add(e2);
      }

      for(Item e : this.pivotIn) {
         Item e2 = e.clone();
         e2.setParent(x);
         x.getPivotIn().add(e2);
      }

      return x;
   }

   public static class Item extends SparkSqlObjectImpl {
      private String alias;
      private SQLExpr expr;

      public String getAlias() {
         return this.alias;
      }

      public void setAlias(String alias) {
         this.alias = alias;
      }

      public SQLExpr getExpr() {
         return this.expr;
      }

      public void setExpr(SQLExpr expr) {
         if (expr != null) {
            expr.setParent(this);
         }

         this.expr = expr;
      }

      public void accept0(SparkVisitor visitor) {
         if (visitor.visit(this)) {
            this.acceptChild(visitor, this.expr);
         }

         visitor.endVisit(this);
      }

      public Item clone() {
         Item x = new Item();
         x.setAlias(this.alias);
         if (this.alias != null) {
            x.setExpr(this.expr.clone());
         }

         return x;
      }
   }
}
