package com.chenyang.druid.sql.dialect.spark.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.statement.SQLShowStatement;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SparkRepairTableStatement extends SQLStatementImpl implements SQLShowStatement, SparkStatement {
   private SQLName name;
   private PartitionAction action;

   public SparkRepairTableStatement() {
      super(DbType.spark);
   }

   public SQLName getName() {
      return this.name;
   }

   public void setName(SQLName name) {
      this.name = name;
   }

   public PartitionAction getAction() {
      return this.action;
   }

   public void setAction(PartitionAction action) {
      this.action = action;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof SparkVisitor) {
         this.accept0((SparkVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.name);
      }

      v.endVisit(this);
   }

   public static enum PartitionAction {
      ADD("ADD"),
      DROP("DROP"),
      SYNC("SYNC");

      public final String name;

      private PartitionAction(String name) {
         this.name = name;
      }
   }
}
