package com.chenyang.druid.sql.dialect.spark.ast.statement;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLStatementImpl;
import com.chenyang.druid.sql.ast.statement.SQLShowStatement;
import com.chenyang.druid.sql.dialect.spark.visitor.SparkVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SparkShowDatabasesStatement extends SQLStatementImpl implements SQLShowStatement, SparkStatement {
   private boolean isDatabases;
   private SQLExpr like;

   public SparkShowDatabasesStatement() {
      super(DbType.spark);
   }

   public SQLExpr getLike() {
      return this.like;
   }

   public void setLike(SQLExpr like) {
      this.like = like;
   }

   protected void accept0(SQLASTVisitor visitor) {
      if (visitor instanceof SparkVisitor) {
         this.accept0((SparkVisitor)visitor);
      } else {
         super.accept0(visitor);
      }

   }

   public void accept0(SparkVisitor v) {
      if (v.visit(this)) {
         this.acceptChild(v, this.like);
      }

      v.endVisit(this);
   }

   public boolean isDatabases() {
      return this.isDatabases;
   }

   public void setDatabases(boolean databases) {
      this.isDatabases = databases;
   }
}
