package com.chenyang.druid.sql.dialect.sqlserver.ast.expr;

import com.chenyang.druid.FastsqlException;
import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.SQLName;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.ast.statement.SQLColumnDefinition;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerObjectImpl;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.chenyang.druid.util.FnvHash;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class SQLServerObjectReferenceExpr extends SQLServerObjectImpl implements SQLServerExpr, SQLName {
   private String server;
   private String database;
   private String schema;
   protected long schemaHashCode64;
   protected long hashCode64;

   public SQLServerObjectReferenceExpr() {
   }

   public SQLServerObjectReferenceExpr(SQLExpr owner) {
      if (owner instanceof SQLIdentifierExpr) {
         this.database = ((SQLIdentifierExpr)owner).getName();
      } else {
         if (!(owner instanceof SQLPropertyExpr)) {
            throw new IllegalArgumentException(owner.toString());
         }

         SQLPropertyExpr propExpr = (SQLPropertyExpr)owner;
         this.server = ((SQLIdentifierExpr)propExpr.getOwner()).getName();
         this.database = propExpr.getName();
      }

   }

   public String getSimpleName() {
      if (this.schema != null) {
         return this.schema;
      } else {
         return this.database != null ? this.database : this.server;
      }
   }

   public void accept0(SQLServerASTVisitor visitor) {
      visitor.visit(this);
      visitor.endVisit(this);
   }

   public void output(Appendable buf) {
      try {
         boolean flag = false;
         if (this.server != null) {
            buf.append(this.server);
            flag = true;
         }

         if (flag) {
            buf.append('.');
         }

         if (this.database != null) {
            buf.append(this.database);
            flag = true;
         }

         if (flag) {
            buf.append('.');
         }

         if (this.schema != null) {
            buf.append(this.schema);
            flag = true;
         }

      } catch (IOException ex) {
         throw new FastsqlException("output error", ex);
      }
   }

   public String getServer() {
      return this.server;
   }

   public void setServer(String server) {
      this.server = server;
   }

   public String getDatabase() {
      return this.database;
   }

   public void setDatabase(String database) {
      this.database = database;
   }

   public String getSchema() {
      return this.schema;
   }

   public void setSchema(String schema) {
      this.schema = schema;
   }

   public SQLServerObjectReferenceExpr clone() {
      SQLServerObjectReferenceExpr x = new SQLServerObjectReferenceExpr();
      x.server = this.server;
      x.database = this.database;
      x.schema = this.schema;
      x.schemaHashCode64 = this.schemaHashCode64;
      x.hashCode64 = this.hashCode64;
      return x;
   }

   public long nameHashCode64() {
      if (this.schemaHashCode64 == 0L && this.schema != null) {
         this.schemaHashCode64 = FnvHash.hashCode64(this.schema);
      }

      return this.schemaHashCode64;
   }

   public long hashCode64() {
      if (this.hashCode64 == 0L) {
         if (this.server == null) {
            this.hashCode64 = (new SQLPropertyExpr(new SQLPropertyExpr(this.server, this.database), this.schema)).hashCode64();
         } else {
            this.hashCode64 = (new SQLPropertyExpr(this.database, this.schema)).hashCode64();
         }
      }

      return this.hashCode64;
   }

   public SQLColumnDefinition getResolvedColumn() {
      return null;
   }

   public List<SQLObject> getChildren() {
      return Collections.emptyList();
   }
}
