package com.chenyang.druid.sql.dialect.sqlserver.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLServerDeleteStatement extends SQLDeleteStatement implements SQLServerObject {
   private SQLServerTop top;
   private SQLServerOutput output;

   public SQLServerDeleteStatement(DbType dbType) {
      super(dbType);
   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.with);
         this.acceptChild(visitor, this.top);
         this.acceptChild(visitor, this.tableSource);
         this.acceptChild(visitor, this.output);
         this.acceptChild(visitor, this.where);
      }

      visitor.endVisit(this);
   }

   public SQLServerTop getTop() {
      return this.top;
   }

   public void setTop(SQLServerTop top) {
      this.top = top;
      this.top.setParent(this);
   }

   protected void cloneTo(SQLDeleteStatement x) {
      SQLServerDeleteStatement statement = new SQLServerDeleteStatement(x.getDbType());
      super.cloneTo(statement);
      if (this.getTop() != null) {
         statement.setTop(this.getTop().clone());
      }

      if (this.getOutput() != null) {
         statement.setOutput(this.getOutput().clone());
      }

   }

   public SQLServerOutput getOutput() {
      return this.output;
   }

   public void setOutput(SQLServerOutput output) {
      this.output = output;
      this.output.setParent(this);
   }
}
