package com.chenyang.druid.sql.dialect.sqlserver.ast.stmt;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerObject;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerOutput;
import com.chenyang.druid.sql.dialect.sqlserver.ast.SQLServerTop;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.SQLServerASTVisitor;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;

public class SQLServerInsertStatement extends SQLInsertStatement implements SQLServerObject {
   private boolean defaultValues;
   private SQLServerTop top;
   private SQLServerOutput output;

   public SQLServerInsertStatement() {
      this.dbType = DbType.sqlserver;
   }

   public void cloneTo(SQLServerInsertStatement x) {
      super.cloneTo(x);
      x.defaultValues = this.defaultValues;
      if (this.top != null) {
         x.setTop(this.top.clone());
      }

      if (this.output != null) {
         x.setOutput(this.output.clone());
      }

   }

   protected void accept0(SQLASTVisitor visitor) {
      this.accept0((SQLServerASTVisitor)visitor);
   }

   public void accept0(SQLServerASTVisitor visitor) {
      if (visitor.visit(this)) {
         this.acceptChild(visitor, this.getWith());
         this.acceptChild(visitor, this.getTop());
         this.acceptChild(visitor, this.getTableSource());
         this.acceptChild(visitor, this.getColumns());
         this.acceptChild(visitor, this.getOutput());
         this.acceptChild(visitor, this.getValuesList());
         this.acceptChild(visitor, this.getQuery());
      }

      visitor.endVisit(this);
   }

   public boolean isDefaultValues() {
      return this.defaultValues;
   }

   public void setDefaultValues(boolean defaultValues) {
      this.defaultValues = defaultValues;
   }

   public SQLServerOutput getOutput() {
      return this.output;
   }

   public void setOutput(SQLServerOutput output) {
      this.output = output;
   }

   public SQLServerTop getTop() {
      return this.top;
   }

   public void setTop(SQLServerTop top) {
      this.top = top;
   }

   public SQLServerInsertStatement clone() {
      SQLServerInsertStatement x = new SQLServerInsertStatement();
      this.cloneTo(x);
      return x;
   }
}
