package com.chenyang.druid.sql.dialect.sqlserver.visitor;

import com.chenyang.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.chenyang.druid.sql.ast.expr.SQLCaseExpr;
import com.chenyang.druid.sql.ast.expr.SQLCharExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLInListExpr;
import com.chenyang.druid.sql.ast.expr.SQLIntegerExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLNullExpr;
import com.chenyang.druid.sql.ast.expr.SQLNumberExpr;
import com.chenyang.druid.sql.ast.expr.SQLNumericLiteralExpr;
import com.chenyang.druid.sql.ast.expr.SQLQueryExpr;
import com.chenyang.druid.sql.ast.expr.SQLUnaryExpr;
import com.chenyang.druid.sql.ast.expr.SQLVariantRefExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import com.chenyang.druid.sql.visitor.SQLEvalVisitorUtils;
import com.chenyang.druid.sql.visitor.functions.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SQLServerEvalVisitor extends SQLServerASTVisitorAdapter implements SQLEvalVisitor {
   private Map<String, Function> functions;
   private List<Object> parameters;
   private int variantIndex;
   private boolean markVariantIndex;

   public SQLServerEvalVisitor() {
      this(new ArrayList(1));
   }

   public SQLServerEvalVisitor(List<Object> parameters) {
      this.functions = new HashMap();
      this.parameters = new ArrayList();
      this.variantIndex = -1;
      this.markVariantIndex = true;
      this.parameters = parameters;
   }

   public List<Object> getParameters() {
      return this.parameters;
   }

   public void setParameters(List<Object> parameters) {
      this.parameters = parameters;
   }

   public boolean visit(SQLCharExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLCharExpr)x);
   }

   public int incrementAndGetVariantIndex() {
      return ++this.variantIndex;
   }

   public int getVariantIndex() {
      return this.variantIndex;
   }

   public boolean visit(SQLVariantRefExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLVariantRefExpr)x);
   }

   public boolean visit(SQLBinaryOpExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLBinaryOpExpr)x);
   }

   public boolean visit(SQLUnaryExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLUnaryExpr)x);
   }

   public boolean visit(SQLIntegerExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLNumericLiteralExpr)x);
   }

   public boolean visit(SQLNumberExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLNumericLiteralExpr)x);
   }

   public boolean visit(SQLCaseExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLCaseExpr)x);
   }

   public boolean visit(SQLInListExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLInListExpr)x);
   }

   public boolean visit(SQLNullExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLNullExpr)x);
   }

   public boolean visit(SQLMethodInvokeExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLMethodInvokeExpr)x);
   }

   public boolean visit(SQLQueryExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLQueryExpr)x);
   }

   public boolean isMarkVariantIndex() {
      return this.markVariantIndex;
   }

   public void setMarkVariantIndex(boolean markVariantIndex) {
      this.markVariantIndex = markVariantIndex;
   }

   public Function getFunction(String funcName) {
      return (Function)this.functions.get(funcName);
   }

   public void registerFunction(String funcName, Function function) {
      this.functions.put(funcName, function);
   }

   public void unregisterFunction(String funcName) {
      this.functions.remove(funcName);
   }

   public boolean visit(SQLIdentifierExpr x) {
      return SQLEvalVisitorUtils.visit(this, (SQLIdentifierExpr)x);
   }
}
