package com.chenyang.druid.sql.repository.function;

import java.lang.reflect.Type;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public class SignatureUtils {
   public static Type getJavaType(String signature) {
      if (signature != null && signature.length() != 0) {
         char c0 = signature.charAt(0);
         if (signature.length() == 1) {
            switch (c0) {
               case 'A':
                  return Date.class;
               case 'B':
                  return Byte.class;
               case 'C':
                  return Character.class;
               case 'D':
                  return Double.class;
               case 'E':
               case 'H':
               case 'K':
               case 'L':
               case 'M':
               case 'N':
               case 'O':
               case 'Q':
               case 'R':
               case 'U':
               case 'V':
               case 'W':
               case 'X':
               case 'Y':
               case 'Z':
               case '[':
               case '\\':
               case ']':
               case '^':
               case '_':
               case '`':
               case 'e':
               case 'h':
               case 'k':
               case 'l':
               case 'm':
               case 'n':
               case 'o':
               case 'q':
               case 'r':
               default:
                  break;
               case 'F':
                  return Float.class;
               case 'G':
                  return String.class;
               case 'I':
                  return Integer.class;
               case 'J':
                  return Long.class;
               case 'P':
                  return Timestamp.class;
               case 'S':
                  return Short.class;
               case 'T':
                  return Time.class;
               case 'a':
                  return Date.class;
               case 'b':
                  return Byte.TYPE;
               case 'c':
                  return Character.TYPE;
               case 'd':
                  return Double.TYPE;
               case 'f':
                  return Float.TYPE;
               case 'g':
                  return String.class;
               case 'i':
                  return Integer.TYPE;
               case 'j':
                  return Long.TYPE;
               case 'p':
                  return Timestamp.class;
               case 's':
                  return Short.TYPE;
               case 't':
                  return Time.class;
            }
         }

         throw new UnsupportedOperationException("type : " + signature + " is not support.");
      } else {
         return null;
      }
   }
}
