package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import com.chenyang.druid.sql.visitor.SQLEvalVisitorUtils;
import java.util.List;

public class If implements Function {
   public static final If instance = new If();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      List<SQLExpr> arguments = x.getArguments();
      if (arguments.size() == 0) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr condition = (SQLExpr)arguments.get(0);
         condition.accept(visitor);
         Object itemValue = condition.getAttributes().get("eval.value");
         if (itemValue == null) {
            return null;
         } else if (Boolean.TRUE != itemValue && SQLEvalVisitorUtils.eq(itemValue, 0)) {
            SQLExpr falseExpr = (SQLExpr)arguments.get(2);
            falseExpr.accept(visitor);
            return falseExpr.getAttributes().get("eval.value");
         } else {
            SQLExpr trueExpr = (SQLExpr)arguments.get(1);
            trueExpr.accept(visitor);
            return trueExpr.getAttributes().get("eval.value");
         }
      }
   }
}
