package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;
import java.util.List;

public class Locate implements Function {
   public static final Locate instance = new Locate();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      List<SQLExpr> params = x.getArguments();
      int paramSize = params.size();
      if (paramSize != 2 && paramSize != 3) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)params.get(0);
         SQLExpr param1 = (SQLExpr)params.get(1);
         SQLExpr param2 = null;
         param0.accept(visitor);
         param1.accept(visitor);
         if (paramSize == 3) {
            param2 = (SQLExpr)params.get(2);
            param2.accept(visitor);
         }

         Object param0Value = param0.getAttributes().get("eval.value");
         Object param1Value = param1.getAttributes().get("eval.value");
         if (param0Value != null && param1Value != null) {
            String strValue0 = param0Value.toString();
            String strValue1 = param1Value.toString();
            if (paramSize == 2) {
               int result = strValue1.indexOf(strValue0) + 1;
               return result;
            } else {
               Object param2Value = param2.getAttributes().get("eval.value");
               int start = ((Number)param2Value).intValue();
               int result = strValue1.indexOf(strValue0, start + 1) + 1;
               return result;
            }
         } else {
            return SQLEvalVisitor.EVAL_ERROR;
         }
      }
   }
}
