package com.chenyang.druid.sql.visitor.functions;

import com.chenyang.druid.sql.ast.SQLExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.visitor.SQLEvalVisitor;

public class Ltrim implements Function {
   public static final Ltrim instance = new Ltrim();

   public Object eval(SQLEvalVisitor visitor, SQLMethodInvokeExpr x) {
      if (x.getArguments().size() != 1) {
         return SQLEvalVisitor.EVAL_ERROR;
      } else {
         SQLExpr param0 = (SQLExpr)x.getArguments().get(0);
         param0.accept(visitor);
         Object param0Value = param0.getAttributes().get("eval.value");
         if (param0Value == null) {
            return SQLEvalVisitor.EVAL_ERROR;
         } else {
            String strValue = param0Value.toString();
            int index = -1;

            for(int i = 0; i < strValue.length(); ++i) {
               if (!Character.isWhitespace(strValue.charAt(i))) {
                  index = i;
                  break;
               }
            }

            return index <= 0 ? strValue : strValue.substring(index);
         }
      }
   }
}
