package com.chenyang.druid.util.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public abstract class ConnectionBase implements Connection {
   private boolean autoCommit = true;
   private String catalog;
   private int transactionIsolation;
   private int holdability;
   private Map<String, Class<?>> typeMap = new HashMap();
   private SQLWarning warnings;
   private boolean readOnly;
   private String url;
   private Properties info;

   public ConnectionBase(String url, Properties info) {
      this.url = url;
      this.info = info;
   }

   public String getUrl() {
      return this.url;
   }

   public Properties getConnectProperties() {
      return this.info;
   }

   public void setAutoCommit(boolean autoCommit) throws SQLException {
      this.autoCommit = autoCommit;
   }

   public boolean getAutoCommit() throws SQLException {
      return this.autoCommit;
   }

   public void setCatalog(String catalog) throws SQLException {
      this.checkState();
      this.catalog = catalog;
   }

   public String getCatalog() throws SQLException {
      return this.catalog;
   }

   public void checkState() throws SQLException {
   }

   public void setTransactionIsolation(int level) throws SQLException {
      this.checkState();
      this.transactionIsolation = level;
   }

   public int getTransactionIsolation() throws SQLException {
      return this.transactionIsolation;
   }

   public SQLWarning getWarnings() throws SQLException {
      return this.warnings;
   }

   public void clearWarnings() throws SQLException {
      this.warnings = null;
   }

   public void setWarnings(SQLWarning warnings) {
      this.warnings = warnings;
   }

   public Map<String, Class<?>> getTypeMap() throws SQLException {
      return this.typeMap;
   }

   public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
      this.typeMap = map;
   }

   public void setHoldability(int holdability) throws SQLException {
      this.holdability = holdability;
   }

   public int getHoldability() {
      return this.holdability;
   }

   public void setReadOnly(boolean readOnly) throws SQLException {
      this.readOnly = readOnly;
   }

   public boolean isReadOnly() throws SQLException {
      return this.readOnly;
   }
}
