package com.chenyang.druid.wall;

import com.chenyang.druid.wall.spi.MySqlWallProvider;
import com.chenyang.druid.wall.spi.OracleWallProvider;
import com.chenyang.druid.wall.spi.SQLServerWallProvider;

public class WallUtils {
   public static boolean isValidateMySql(String sql) {
      MySqlWallProvider provider = new MySqlWallProvider();
      return provider.checkValid(sql);
   }

   public static boolean isValidateMySql(String sql, WallConfig config) {
      MySqlWallProvider provider = new MySqlWallProvider(config);
      return provider.checkValid(sql);
   }

   public static boolean isValidateOracle(String sql) {
      OracleWallProvider provider = new OracleWallProvider();
      return provider.checkValid(sql);
   }

   public static boolean isValidateOracle(String sql, WallConfig config) {
      OracleWallProvider provider = new OracleWallProvider(config);
      return provider.checkValid(sql);
   }

   public static boolean isValidateSqlServer(String sql) {
      SQLServerWallProvider provider = new SQLServerWallProvider();
      return provider.checkValid(sql);
   }

   public static boolean isValidateSqlServer(String sql, WallConfig config) {
      SQLServerWallProvider provider = new SQLServerWallProvider(config);
      return provider.checkValid(sql);
   }
}
