package com.chenyang.druid.wall;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.ast.SQLCommentHint;
import com.chenyang.druid.sql.ast.SQLLimit;
import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.expr.SQLInListExpr;
import com.chenyang.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.chenyang.druid.sql.ast.expr.SQLPropertyExpr;
import com.chenyang.druid.sql.ast.statement.SQLAlterTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLCallStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLCreateTriggerStatement;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLDropTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLSelectGroupByClause;
import com.chenyang.druid.sql.ast.statement.SQLSelectItem;
import com.chenyang.druid.sql.ast.statement.SQLSelectQueryBlock;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSetStatement;
import com.chenyang.druid.sql.ast.statement.SQLShowCreateTableStatement;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.visitor.SQLASTVisitor;
import java.util.List;

public interface WallVisitor extends SQLASTVisitor {
   WallConfig getConfig();

   WallProvider getProvider();

   List<Violation> getViolations();

   void addViolation(Violation var1);

   boolean isDenyTable(String var1);

   String toSQL(SQLObject var1);

   boolean isSqlModified();

   void setSqlModified(boolean var1);

   DbType getDbType();

   boolean isSqlEndOfComment();

   void setSqlEndOfComment(boolean var1);

   void addWallUpdateCheckItem(WallUpdateCheckItem var1);

   List<WallUpdateCheckItem> getUpdateCheckItems();

   boolean visit(SQLPropertyExpr var1);

   boolean visit(SQLInListExpr var1);

   boolean visit(SQLBinaryOpExpr var1);

   boolean visit(SQLMethodInvokeExpr var1);

   boolean visit(SQLSelectQueryBlock var1);

   boolean visit(SQLSelectGroupByClause var1);

   boolean visit(SQLSelectItem var1);

   boolean visit(SQLJoinTableSource var1);

   boolean visit(SQLCreateTableStatement var1);

   boolean visit(SQLAlterTableStatement var1);

   boolean visit(SQLDropTableStatement var1);

   boolean visit(SQLUpdateStatement var1);

   void endVisit(SQLUpdateStatement var1);

   boolean visit(SQLInsertStatement var1);

   void endVisit(SQLInsertStatement var1);

   boolean visit(SQLDeleteStatement var1);

   void preVisit(SQLObject var1);

   boolean visit(SQLSelectStatement var1);

   void endVisit(SQLSelectStatement var1);

   boolean visit(SQLExprTableSource var1);

   boolean visit(SQLIdentifierExpr var1);

   boolean visit(SQLUnionQuery var1);

   void endVisit(SQLDeleteStatement var1);

   boolean visit(SQLLimit var1);

   boolean visit(SQLCreateTriggerStatement var1);

   boolean visit(SQLSetStatement var1);

   boolean visit(SQLCallStatement var1);

   boolean visit(SQLCommentHint var1);

   boolean visit(SQLShowCreateTableStatement var1);
}
