package com.chenyang.druid.wall.spi;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.dialect.oracle.parser.OracleStatementParser;
import com.chenyang.druid.sql.dialect.oracle.visitor.OracleExportParameterVisitor;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.SQLStatementParser;
import com.chenyang.druid.sql.visitor.ExportParameterVisitor;
import com.chenyang.druid.wall.WallConfig;
import com.chenyang.druid.wall.WallProvider;
import com.chenyang.druid.wall.WallVisitor;

public class OracleWallProvider extends WallProvider {
   public static final String DEFAULT_CONFIG_DIR = "META-INF/druid/wall/oracle";

   public OracleWallProvider() {
      this(new WallConfig("META-INF/druid/wall/oracle"));
   }

   public OracleWallProvider(WallConfig config) {
      super(config, DbType.oracle);
   }

   public SQLStatementParser createParser(String sql) {
      return new OracleStatementParser(sql, new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup});
   }

   public WallVisitor createWallVisitor() {
      return new OracleWallVisitor(this);
   }

   public ExportParameterVisitor createExportParameterVisitor() {
      return new OracleExportParameterVisitor();
   }
}
