package com.chenyang.druid.wall.spi;

import com.chenyang.druid.DbType;
import com.chenyang.druid.sql.dialect.sqlserver.parser.SQLServerStatementParser;
import com.chenyang.druid.sql.dialect.sqlserver.visitor.MSSQLServerExportParameterVisitor;
import com.chenyang.druid.sql.parser.SQLParserFeature;
import com.chenyang.druid.sql.parser.SQLStatementParser;
import com.chenyang.druid.sql.visitor.ExportParameterVisitor;
import com.chenyang.druid.wall.WallConfig;
import com.chenyang.druid.wall.WallProvider;
import com.chenyang.druid.wall.WallVisitor;

public class SQLServerWallProvider extends WallProvider {
   public static final String DEFAULT_CONFIG_DIR = "META-INF/druid/wall/sqlserver";

   public SQLServerWallProvider() {
      this(new WallConfig("META-INF/druid/wall/sqlserver"));
   }

   public SQLServerWallProvider(WallConfig config) {
      super(config, DbType.sqlserver);
   }

   public SQLStatementParser createParser(String sql) {
      return new SQLServerStatementParser(sql, new SQLParserFeature[]{SQLParserFeature.EnableSQLBinaryOpExprGroup});
   }

   public WallVisitor createWallVisitor() {
      return new SQLServerWallVisitor(this);
   }

   public ExportParameterVisitor createExportParameterVisitor() {
      return new MSSQLServerExportParameterVisitor();
   }
}
