package com.chenyang.fastjson.util;

import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

import com.chenyang.fastjson.JSON;
import com.chenyang.fastjson.JSONArray;
import com.chenyang.fastjson.JSONAware;
import com.chenyang.fastjson.JSONException;
import com.chenyang.fastjson.JSONObject;
import com.chenyang.fastjson.JSONPath;
import com.chenyang.fastjson.JSONPathException;
import com.chenyang.fastjson.JSONReader;
import com.chenyang.fastjson.JSONStreamAware;
import com.chenyang.fastjson.JSONWriter;
import com.chenyang.fastjson.TypeReference;
import com.chenyang.fastjson.parser.DefaultJSONParser;
import com.chenyang.fastjson.parser.Feature;
import com.chenyang.fastjson.parser.JSONLexer;
import com.chenyang.fastjson.parser.JSONLexerBase;
import com.chenyang.fastjson.parser.JSONReaderScanner;
import com.chenyang.fastjson.parser.JSONScanner;
import com.chenyang.fastjson.parser.JSONToken;
import com.chenyang.fastjson.parser.ParseContext;
import com.chenyang.fastjson.parser.ParserConfig;
import com.chenyang.fastjson.parser.SymbolTable;
import com.chenyang.fastjson.parser.deserializer.AutowiredObjectDeserializer;
import com.chenyang.fastjson.parser.deserializer.DefaultFieldDeserializer;
import com.chenyang.fastjson.parser.deserializer.ExtraProcessable;
import com.chenyang.fastjson.parser.deserializer.ExtraProcessor;
import com.chenyang.fastjson.parser.deserializer.ExtraTypeProvider;
import com.chenyang.fastjson.parser.deserializer.FieldDeserializer;
import com.chenyang.fastjson.parser.deserializer.JavaBeanDeserializer;
import com.chenyang.fastjson.parser.deserializer.ObjectDeserializer;
import com.chenyang.fastjson.serializer.AfterFilter;
import com.chenyang.fastjson.serializer.BeanContext;
import com.chenyang.fastjson.serializer.BeforeFilter;
import com.chenyang.fastjson.serializer.ContextObjectSerializer;
import com.chenyang.fastjson.serializer.ContextValueFilter;
import com.chenyang.fastjson.serializer.JSONSerializer;
import com.chenyang.fastjson.serializer.JavaBeanSerializer;
import com.chenyang.fastjson.serializer.LabelFilter;
import com.chenyang.fastjson.serializer.Labels;
import com.chenyang.fastjson.serializer.NameFilter;
import com.chenyang.fastjson.serializer.ObjectSerializer;
import com.chenyang.fastjson.serializer.PropertyFilter;
import com.chenyang.fastjson.serializer.PropertyPreFilter;
import com.chenyang.fastjson.serializer.SerialContext;
import com.chenyang.fastjson.serializer.SerializeBeanInfo;
import com.chenyang.fastjson.serializer.SerializeConfig;
import com.chenyang.fastjson.serializer.SerializeFilter;
import com.chenyang.fastjson.serializer.SerializeFilterable;
import com.chenyang.fastjson.serializer.SerializeWriter;
import com.chenyang.fastjson.serializer.SerializerFeature;
import com.chenyang.fastjson.serializer.ValueFilter;

public class ASMClassLoader extends ClassLoader {

    private static java.security.ProtectionDomain DOMAIN;
    
    private static Map<String, Class<?>> classMapping = new HashMap<String, Class<?>>();

    static {
        DOMAIN = (java.security.ProtectionDomain) java.security.AccessController.doPrivileged(new PrivilegedAction<Object>() {

            public Object run() {
                return ASMClassLoader.class.getProtectionDomain();
            }
        });
        
        Class<?>[] jsonClasses = new Class<?>[] {JSON.class,
            JSONObject.class,
            JSONArray.class,
            JSONPath.class,
            JSONAware.class,
            JSONException.class,
            JSONPathException.class,
            JSONReader.class,
            JSONStreamAware.class,
            JSONWriter.class,
            TypeReference.class,
                    
            FieldInfo.class,
            TypeUtils.class,
            IOUtils.class,
            IdentityHashMap.class,
            ParameterizedTypeImpl.class,
            JavaBeanInfo.class,
                    
            ObjectSerializer.class,
            JavaBeanSerializer.class,
            SerializeFilterable.class,
            SerializeBeanInfo.class,
            JSONSerializer.class,
            SerializeWriter.class,
            SerializeFilter.class,
            Labels.class,
            LabelFilter.class,
            ContextValueFilter.class,
            AfterFilter.class,
            BeforeFilter.class,
            NameFilter.class,
            PropertyFilter.class,
            PropertyPreFilter.class,
            ValueFilter.class,
            SerializerFeature.class,
            ContextObjectSerializer.class,
            SerialContext.class,
            SerializeConfig.class,
                    
            JavaBeanDeserializer.class,
            ParserConfig.class,
            DefaultJSONParser.class,
            JSONLexer.class,
            JSONLexerBase.class,
            ParseContext.class,
            JSONToken.class,
            SymbolTable.class,
            Feature.class,
            JSONScanner.class,
            JSONReaderScanner.class,
                    
            AutowiredObjectDeserializer.class,
            ObjectDeserializer.class,
            ExtraProcessor.class,
            ExtraProcessable.class,
            ExtraTypeProvider.class,
            BeanContext.class,
            FieldDeserializer.class,
            DefaultFieldDeserializer.class,
        };
        
        for (Class<?> clazz : jsonClasses) {
            classMapping.put(clazz.getName(), clazz);
        }
    }
    
    public ASMClassLoader(){
        super(getParentClassLoader());
    }

    public ASMClassLoader(ClassLoader parent){
        super (parent);
    }

    static ClassLoader getParentClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                contextClassLoader.loadClass(JSON.class.getName());
                return contextClassLoader;
            } catch (ClassNotFoundException e) {
                // skip
            }
        }
        return JSON.class.getClassLoader();
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> mappingClass = classMapping.get(name);
        if (mappingClass != null) {
            return mappingClass;
        }
        
        try {
            return super.loadClass(name, resolve);
        } catch (ClassNotFoundException e) {
            throw e;
        }
    }

    public Class<?> defineClassPublic(String name, byte[] b, int off, int len) throws ClassFormatError {
        Class<?> clazz = defineClass(name, b, off, len, DOMAIN);

        return clazz;
    }

    public boolean isExternalClass(Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();

        if (classLoader == null) {
            return false;
        }

        ClassLoader current = this;
        while (current != null) {
            if (current == classLoader) {
                return false;
            }

            current = current.getParent();
        }

        return true;
    }

}
