package org.chenyang.http.auth;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.util.Args;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public final class AuthOption {
   private final AuthScheme authScheme;
   private final Credentials creds;

   public AuthOption(AuthScheme authScheme, Credentials creds) {
      Args.notNull(authScheme, "Auth scheme");
      Args.notNull(creds, "User credentials");
      this.authScheme = authScheme;
      this.creds = creds;
   }

   public AuthScheme getAuthScheme() {
      return this.authScheme;
   }

   public Credentials getCredentials() {
      return this.creds;
   }

   public String toString() {
      return this.authScheme.toString();
   }
}
