package org.chenyang.http.auth.params;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.protocol.HTTP;
import org.chenyang.http.util.Args;

/** @deprecated */
@Deprecated
@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public final class AuthParams {
   private AuthParams() {
   }

   public static String getCredentialCharset(HttpParams params) {
      Args.notNull(params, "HTTP parameters");
      String charset = (String)params.getParameter("http.auth.credential-charset");
      if (charset == null) {
         charset = HTTP.DEF_PROTOCOL_CHARSET.name();
      }

      return charset;
   }

   public static void setCredentialCharset(HttpParams params, String charset) {
      Args.notNull(params, "HTTP parameters");
      params.setParameter("http.auth.credential-charset", charset);
   }
}
