package org.chenyang.http.client.entity;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class GZIPInputStreamFactory implements InputStreamFactory {
   private static final GZIPInputStreamFactory INSTANCE = new GZIPInputStreamFactory();

   public static GZIPInputStreamFactory getInstance() {
      return INSTANCE;
   }

   public InputStream create(InputStream inputStream) throws IOException {
      return new GZIPInputStream(inputStream);
   }
}
