package org.chenyang.http.conn.socket;

import org.chenyang.http.HttpHost;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.protocol.HttpContext;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class PlainConnectionSocketFactory implements ConnectionSocketFactory {
   public static final PlainConnectionSocketFactory INSTANCE = new PlainConnectionSocketFactory();

   public static PlainConnectionSocketFactory getSocketFactory() {
      return INSTANCE;
   }

   public Socket createSocket(HttpContext context) throws IOException {
      return new Socket();
   }

   public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
      Socket sock = socket != null ? socket : this.createSocket(context);
      if (localAddress != null) {
         sock.bind(localAddress);
      }

      try {
         sock.connect(remoteAddress, connectTimeout);
         return sock;
      } catch (IOException ex) {
         try {
            sock.close();
         } catch (IOException var10) {
         }

         throw ex;
      }
   }
}
