package org.chenyang.http.impl;

import org.chenyang.http.HttpClientConnection;
import org.chenyang.http.HttpConnectionMetrics;
import org.chenyang.http.HttpEntity;
import org.chenyang.http.HttpEntityEnclosingRequest;
import org.chenyang.http.HttpException;
import org.chenyang.http.HttpRequest;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.HttpResponseFactory;
import org.chenyang.http.impl.entity.EntityDeserializer;
import org.chenyang.http.impl.entity.EntitySerializer;
import org.chenyang.http.impl.entity.LaxContentLengthStrategy;
import org.chenyang.http.impl.entity.StrictContentLengthStrategy;
import org.chenyang.http.impl.io.DefaultHttpResponseParser;
import org.chenyang.http.impl.io.HttpRequestWriter;
import org.chenyang.http.io.EofSensor;
import org.chenyang.http.io.HttpMessageParser;
import org.chenyang.http.io.HttpMessageWriter;
import org.chenyang.http.io.HttpTransportMetrics;
import org.chenyang.http.io.SessionInputBuffer;
import org.chenyang.http.io.SessionOutputBuffer;
import org.chenyang.http.message.LineFormatter;
import org.chenyang.http.message.LineParser;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.util.Args;
import java.io.IOException;
import java.net.SocketTimeoutException;

/** @deprecated */
@Deprecated
public abstract class AbstractHttpClientConnection implements HttpClientConnection {
   private final EntitySerializer entityserializer = this.createEntitySerializer();
   private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
   private SessionInputBuffer inBuffer = null;
   private SessionOutputBuffer outbuffer = null;
   private EofSensor eofSensor = null;
   private HttpMessageParser<HttpResponse> responseParser = null;
   private HttpMessageWriter<HttpRequest> requestWriter = null;
   private HttpConnectionMetricsImpl metrics = null;

   protected abstract void assertOpen() throws IllegalStateException;

   protected EntityDeserializer createEntityDeserializer() {
      return new EntityDeserializer(new LaxContentLengthStrategy());
   }

   protected EntitySerializer createEntitySerializer() {
      return new EntitySerializer(new StrictContentLengthStrategy());
   }

   protected HttpResponseFactory createHttpResponseFactory() {
      return DefaultHttpResponseFactory.INSTANCE;
   }

   protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
      return new DefaultHttpResponseParser(buffer, (LineParser)null, responseFactory, params);
   }

   protected HttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
      return new HttpRequestWriter(buffer, (LineFormatter)null, params);
   }

   protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
      return new HttpConnectionMetricsImpl(inTransportMetric, outTransportMetric);
   }

   protected void init(SessionInputBuffer sessionInputBuffer, SessionOutputBuffer sessionOutputBuffer, HttpParams params) {
      this.inBuffer = (SessionInputBuffer)Args.notNull(sessionInputBuffer, "Input session buffer");
      this.outbuffer = (SessionOutputBuffer)Args.notNull(sessionOutputBuffer, "Output session buffer");
      if (sessionInputBuffer instanceof EofSensor) {
         this.eofSensor = (EofSensor)sessionInputBuffer;
      }

      this.responseParser = this.createResponseParser(sessionInputBuffer, this.createHttpResponseFactory(), params);
      this.requestWriter = this.createRequestWriter(sessionOutputBuffer, params);
      this.metrics = this.createConnectionMetrics(sessionInputBuffer.getMetrics(), sessionOutputBuffer.getMetrics());
   }

   public boolean isResponseAvailable(int timeout) throws IOException {
      this.assertOpen();

      try {
         return this.inBuffer.isDataAvailable(timeout);
      } catch (SocketTimeoutException var3) {
         return false;
      }
   }

   public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
      Args.notNull(request, "HTTP request");
      this.assertOpen();
      this.requestWriter.write(request);
      this.metrics.incrementRequestCount();
   }

   public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
      Args.notNull(request, "HTTP request");
      this.assertOpen();
      if (request.getEntity() != null) {
         this.entityserializer.serialize(this.outbuffer, request, request.getEntity());
      }

   }

   protected void doFlush() throws IOException {
      this.outbuffer.flush();
   }

   public void flush() throws IOException {
      this.assertOpen();
      this.doFlush();
   }

   public HttpResponse receiveResponseHeader() throws HttpException, IOException {
      this.assertOpen();
      HttpResponse response = this.responseParser.parse();
      if (response.getStatusLine().getStatusCode() >= 200) {
         this.metrics.incrementResponseCount();
      }

      return response;
   }

   public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
      Args.notNull(response, "HTTP response");
      this.assertOpen();
      HttpEntity entity = this.entitydeserializer.deserialize(this.inBuffer, response);
      response.setEntity(entity);
   }

   protected boolean isEof() {
      return this.eofSensor != null && this.eofSensor.isEof();
   }

   public boolean isStale() {
      if (!this.isOpen()) {
         return true;
      } else if (this.isEof()) {
         return true;
      } else {
         try {
            this.inBuffer.isDataAvailable(1);
            return this.isEof();
         } catch (SocketTimeoutException var2) {
            return false;
         } catch (IOException var3) {
            return true;
         }
      }
   }

   public HttpConnectionMetrics getMetrics() {
      return this.metrics;
   }
}
