package org.chenyang.http.impl.auth;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.auth.AuthScheme;
import org.chenyang.http.auth.AuthSchemeFactory;
import org.chenyang.http.auth.AuthSchemeProvider;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.protocol.HttpContext;
import java.nio.charset.Charset;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class DigestSchemeFactory implements AuthSchemeFactory, AuthSchemeProvider {
   private final Charset charset;

   public DigestSchemeFactory(Charset charset) {
      this.charset = charset;
   }

   public DigestSchemeFactory() {
      this((Charset)null);
   }

   public AuthScheme newInstance(HttpParams params) {
      return new DigestScheme();
   }

   public AuthScheme create(HttpContext context) {
      return new DigestScheme(this.charset);
   }
}
