package org.chenyang.http.impl.auth;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.auth.AuthScheme;
import org.chenyang.http.auth.AuthSchemeFactory;
import org.chenyang.http.auth.AuthSchemeProvider;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.protocol.HttpContext;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class NTLMSchemeFactory implements AuthSchemeFactory, AuthSchemeProvider {
   public AuthScheme newInstance(HttpParams params) {
      return new NTLMScheme();
   }

   public AuthScheme create(HttpContext context) {
      return new NTLMScheme();
   }
}
