package org.chenyang.http.impl.client;

import org.chenyang.http.HttpEntity;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.StatusLine;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.client.HttpResponseException;
import org.chenyang.http.client.ResponseHandler;
import org.chenyang.http.util.EntityUtils;
import java.io.IOException;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public abstract class AbstractResponseHandler<T> implements ResponseHandler<T> {
   public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
      StatusLine statusLine = response.getStatusLine();
      HttpEntity entity = response.getEntity();
      if (statusLine.getStatusCode() >= 300) {
         EntityUtils.consume(entity);
         throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
      } else {
         return (T)(entity == null ? null : this.handleEntity(entity));
      }
   }

   public abstract T handleEntity(HttpEntity var1) throws IOException;
}
