package org.chenyang.http.impl.client;

import org.chenyang.http.HttpEntity;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.client.HttpResponseException;
import org.chenyang.http.util.EntityUtils;
import java.io.IOException;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class BasicResponseHandler extends AbstractResponseHandler<String> {
   public String handleEntity(HttpEntity entity) throws IOException {
      return EntityUtils.toString(entity);
   }

   public String handleResponse(HttpResponse response) throws HttpResponseException, IOException {
      return (String)super.handleResponse(response);
   }
}
