package org.chenyang.http.impl.client;

import org.chenyang.http.HttpEntity;
import org.chenyang.http.HttpEntityEnclosingRequest;
import org.chenyang.http.HttpException;
import org.chenyang.http.HttpHost;
import org.chenyang.http.HttpRequest;
import org.chenyang.http.HttpRequestInterceptor;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.HttpResponseInterceptor;
import org.chenyang.http.client.ClientProtocolException;
import org.chenyang.http.client.HttpClient;
import org.chenyang.http.client.ResponseHandler;
import org.chenyang.http.client.methods.HttpUriRequest;
import org.chenyang.http.client.protocol.RequestAcceptEncoding;
import org.chenyang.http.client.protocol.ResponseContentEncoding;
import org.chenyang.http.client.utils.URIUtils;
import org.chenyang.http.conn.ClientConnectionManager;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.protocol.BasicHttpContext;
import org.chenyang.http.protocol.HttpContext;
import org.chenyang.http.util.EntityUtils;
import java.io.IOException;
import java.net.URI;

/** @deprecated */
@Deprecated
public class DecompressingHttpClient implements HttpClient {
   private final HttpClient backend;
   private final HttpRequestInterceptor acceptEncodingInterceptor;
   private final HttpResponseInterceptor contentEncodingInterceptor;

   public DecompressingHttpClient() {
      this(new DefaultHttpClient());
   }

   public DecompressingHttpClient(HttpClient backend) {
      this(backend, new RequestAcceptEncoding(), new ResponseContentEncoding());
   }

   DecompressingHttpClient(HttpClient backend, HttpRequestInterceptor requestInterceptor, HttpResponseInterceptor responseInterceptor) {
      this.backend = backend;
      this.acceptEncodingInterceptor = requestInterceptor;
      this.contentEncodingInterceptor = responseInterceptor;
   }

   public HttpParams getParams() {
      return this.backend.getParams();
   }

   public ClientConnectionManager getConnectionManager() {
      return this.backend.getConnectionManager();
   }

   public HttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
      return this.execute((HttpHost)this.getHttpHost(request), request, (HttpContext)null);
   }

   public HttpClient getHttpClient() {
      return this.backend;
   }

   HttpHost getHttpHost(HttpUriRequest request) {
      URI uri = request.getURI();
      return URIUtils.extractHost(uri);
   }

   public HttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
      return this.execute((HttpHost)this.getHttpHost(request), request, context);
   }

   public HttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
      return this.execute(target, request, (HttpContext)null);
   }

   public HttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
      try {
         HttpContext localContext = (HttpContext)(context != null ? context : new BasicHttpContext());
         HttpRequest wrapped;
         if (request instanceof HttpEntityEnclosingRequest) {
            wrapped = new EntityEnclosingRequestWrapper((HttpEntityEnclosingRequest)request);
         } else {
            wrapped = new RequestWrapper(request);
         }

         this.acceptEncodingInterceptor.process(wrapped, localContext);
         HttpResponse response = this.backend.execute(target, wrapped, localContext);

         try {
            this.contentEncodingInterceptor.process(response, localContext);
            if (Boolean.TRUE.equals(localContext.getAttribute("http.client.response.uncompressed"))) {
               response.removeHeaders("Content-Length");
               response.removeHeaders("Content-Encoding");
               response.removeHeaders("Content-MD5");
            }

            return response;
         } catch (HttpException ex) {
            EntityUtils.consume(response.getEntity());
            throw ex;
         } catch (IOException ex) {
            EntityUtils.consume(response.getEntity());
            throw ex;
         } catch (RuntimeException ex) {
            EntityUtils.consume(response.getEntity());
            throw ex;
         }
      } catch (HttpException e) {
         throw new ClientProtocolException(e);
      }
   }

   public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
      return (T)this.execute((HttpHost)this.getHttpHost(request), request, (ResponseHandler)responseHandler);
   }

   public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
      return (T)this.execute(this.getHttpHost(request), request, responseHandler, context);
   }

   public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
      return (T)this.execute(target, request, responseHandler, (HttpContext)null);
   }

   public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
      HttpResponse response = this.execute(target, request, context);

      Object var6;
      try {
         var6 = responseHandler.handleResponse(response);
      } finally {
         HttpEntity entity = response.getEntity();
         if (entity != null) {
            EntityUtils.consume(entity);
         }

      }

      return (T)var6;
   }
}
