package org.chenyang.http.impl.client;

import org.chenyang.http.HttpResponse;
import org.chenyang.http.client.ConnectionBackoffStrategy;
import java.net.ConnectException;
import java.net.SocketTimeoutException;

public class DefaultBackoffStrategy implements ConnectionBackoffStrategy {
   public boolean shouldBackoff(Throwable t) {
      return t instanceof SocketTimeoutException || t instanceof ConnectException;
   }

   public boolean shouldBackoff(HttpResponse resp) {
      return resp.getStatusLine().getStatusCode() == 429 || resp.getStatusLine().getStatusCode() == 503;
   }
}
