package org.chenyang.http.impl.client;

import org.chenyang.http.HttpRequestInterceptor;
import org.chenyang.http.HttpResponseInterceptor;
import org.chenyang.http.HttpVersion;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.client.protocol.RequestAddCookies;
import org.chenyang.http.client.protocol.RequestAuthCache;
import org.chenyang.http.client.protocol.RequestClientConnControl;
import org.chenyang.http.client.protocol.RequestDefaultHeaders;
import org.chenyang.http.client.protocol.RequestProxyAuthentication;
import org.chenyang.http.client.protocol.RequestTargetAuthentication;
import org.chenyang.http.client.protocol.ResponseProcessCookies;
import org.chenyang.http.conn.ClientConnectionManager;
import org.chenyang.http.params.HttpConnectionParams;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.params.HttpProtocolParams;
import org.chenyang.http.params.SyncBasicHttpParams;
import org.chenyang.http.protocol.BasicHttpProcessor;
import org.chenyang.http.protocol.HTTP;
import org.chenyang.http.protocol.RequestContent;
import org.chenyang.http.protocol.RequestExpectContinue;
import org.chenyang.http.protocol.RequestTargetHost;
import org.chenyang.http.protocol.RequestUserAgent;
import org.chenyang.http.util.VersionInfo;

/** @deprecated */
@Deprecated
@Contract(
   threading = ThreadingBehavior.SAFE_CONDITIONAL
)
public class DefaultHttpClient extends AbstractHttpClient {
   public DefaultHttpClient(ClientConnectionManager conman, HttpParams params) {
      super(conman, params);
   }

   public DefaultHttpClient(ClientConnectionManager conman) {
      super(conman, (HttpParams)null);
   }

   public DefaultHttpClient(HttpParams params) {
      super((ClientConnectionManager)null, params);
   }

   public DefaultHttpClient() {
      super((ClientConnectionManager)null, (HttpParams)null);
   }

   protected HttpParams createHttpParams() {
      HttpParams params = new SyncBasicHttpParams();
      setDefaultHttpParams(params);
      return params;
   }

   public static void setDefaultHttpParams(HttpParams params) {
      HttpProtocolParams.setVersion(params, HttpVersion.HTTP_1_1);
      HttpProtocolParams.setContentCharset(params, HTTP.DEF_CONTENT_CHARSET.name());
      HttpConnectionParams.setTcpNoDelay(params, true);
      HttpConnectionParams.setSocketBufferSize(params, 8192);
      HttpProtocolParams.setUserAgent(params, VersionInfo.getUserAgent("Apache-HttpClient", "ghca.org.apache.http.client", DefaultHttpClient.class));
   }

   protected BasicHttpProcessor createHttpProcessor() {
      BasicHttpProcessor httpproc = new BasicHttpProcessor();
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestDefaultHeaders()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestContent()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestTargetHost()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestClientConnControl()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestUserAgent()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestExpectContinue()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestAddCookies()));
      httpproc.addInterceptor((HttpResponseInterceptor)(new ResponseProcessCookies()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestAuthCache()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestTargetAuthentication()));
      httpproc.addInterceptor((HttpRequestInterceptor)(new RequestProxyAuthentication()));
      return httpproc;
   }
}
