package org.chenyang.http.impl.client;

import org.chenyang.http.conn.HttpClientConnectionManager;
import org.chenyang.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClients {
   private HttpClients() {
   }

   public static HttpClientBuilder custom() {
      return HttpClientBuilder.create();
   }

   public static CloseableHttpClient createDefault() {
      return HttpClientBuilder.create().build();
   }

   public static CloseableHttpClient createSystem() {
      return HttpClientBuilder.create().useSystemProperties().build();
   }

   public static CloseableHttpClient createMinimal() {
      return new MinimalHttpClient(new PoolingHttpClientConnectionManager());
   }

   public static CloseableHttpClient createMinimal(HttpClientConnectionManager connManager) {
      return new MinimalHttpClient(connManager);
   }
}
