package org.chenyang.http.impl.client;

import org.chenyang.http.ConnectionReuseStrategy;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.conn.ClientConnectionManager;
import org.chenyang.http.conn.routing.HttpRoutePlanner;
import org.chenyang.http.impl.DefaultConnectionReuseStrategy;
import org.chenyang.http.impl.NoConnectionReuseStrategy;
import org.chenyang.http.impl.conn.PoolingClientConnectionManager;
import org.chenyang.http.impl.conn.ProxySelectorRoutePlanner;
import org.chenyang.http.impl.conn.SchemeRegistryFactory;
import org.chenyang.http.params.HttpParams;
import java.net.ProxySelector;

/** @deprecated */
@Deprecated
@Contract(
   threading = ThreadingBehavior.SAFE_CONDITIONAL
)
public class SystemDefaultHttpClient extends DefaultHttpClient {
   public SystemDefaultHttpClient(HttpParams params) {
      super((ClientConnectionManager)null, params);
   }

   public SystemDefaultHttpClient() {
      super((ClientConnectionManager)null, (HttpParams)null);
   }

   protected ClientConnectionManager createClientConnectionManager() {
      PoolingClientConnectionManager connmgr = new PoolingClientConnectionManager(SchemeRegistryFactory.createSystemDefault());
      String s = System.getProperty("http.keepAlive", "true");
      if ("true".equalsIgnoreCase(s)) {
         s = System.getProperty("http.maxConnections", "5");
         int max = Integer.parseInt(s);
         connmgr.setDefaultMaxPerRoute(max);
         connmgr.setMaxTotal(2 * max);
      }

      return connmgr;
   }

   protected HttpRoutePlanner createHttpRoutePlanner() {
      return new ProxySelectorRoutePlanner(this.getConnectionManager().getSchemeRegistry(), ProxySelector.getDefault());
   }

   protected ConnectionReuseStrategy createConnectionReuseStrategy() {
      String s = System.getProperty("http.keepAlive", "true");
      return (ConnectionReuseStrategy)("true".equalsIgnoreCase(s) ? new DefaultConnectionReuseStrategy() : new NoConnectionReuseStrategy());
   }
}
