package org.chenyang.http.impl.conn;

import org.chenyang.http.HttpHost;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.conn.SchemePortResolver;
import org.chenyang.http.conn.UnsupportedSchemeException;
import org.chenyang.http.util.Args;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class DefaultSchemePortResolver implements SchemePortResolver {
   public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

   public int resolve(HttpHost host) throws UnsupportedSchemeException {
      Args.notNull(host, "HTTP host");
      int port = host.getPort();
      if (port > 0) {
         return port;
      } else {
         String name = host.getSchemeName();
         if (name.equalsIgnoreCase("http")) {
            return 80;
         } else if (name.equalsIgnoreCase("https")) {
            return 443;
         } else {
            throw new UnsupportedSchemeException(name + " protocol is not supported");
         }
      }
   }
}
