package org.chenyang.http.impl.cookie;

import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.cookie.CommonCookieAttributeHandler;
import org.chenyang.http.cookie.Cookie;
import org.chenyang.http.cookie.CookieOrigin;
import org.chenyang.http.cookie.MalformedCookieException;
import org.chenyang.http.cookie.SetCookie;
import org.chenyang.http.cookie.SetCookie2;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class RFC2965DiscardAttributeHandler implements CommonCookieAttributeHandler {
   public void parse(SetCookie cookie, String commenturl) throws MalformedCookieException {
      if (cookie instanceof SetCookie2) {
         SetCookie2 cookie2 = (SetCookie2)cookie;
         cookie2.setDiscard(true);
      }

   }

   public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
   }

   public boolean match(Cookie cookie, CookieOrigin origin) {
      return true;
   }

   public String getAttributeName() {
      return "discard";
   }
}
