package org.chenyang.http.impl.io;

import org.chenyang.http.Header;
import org.chenyang.http.HeaderIterator;
import org.chenyang.http.HttpException;
import org.chenyang.http.HttpMessage;
import org.chenyang.http.io.HttpMessageWriter;
import org.chenyang.http.io.SessionOutputBuffer;
import org.chenyang.http.message.BasicLineFormatter;
import org.chenyang.http.message.LineFormatter;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.util.Args;
import org.chenyang.http.util.CharArrayBuffer;
import java.io.IOException;

public abstract class AbstractMessageWriter<T extends HttpMessage> implements HttpMessageWriter<T> {
   protected final SessionOutputBuffer sessionBuffer;
   protected final CharArrayBuffer lineBuf;
   protected final LineFormatter lineFormatter;

   /** @deprecated */
   @Deprecated
   public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter, HttpParams params) {
      Args.notNull(buffer, "Session input buffer");
      this.sessionBuffer = buffer;
      this.lineBuf = new CharArrayBuffer(128);
      this.lineFormatter = (LineFormatter)(formatter != null ? formatter : BasicLineFormatter.INSTANCE);
   }

   public AbstractMessageWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
      this.sessionBuffer = (SessionOutputBuffer)Args.notNull(buffer, "Session input buffer");
      this.lineFormatter = (LineFormatter)(formatter != null ? formatter : BasicLineFormatter.INSTANCE);
      this.lineBuf = new CharArrayBuffer(128);
   }

   protected abstract void writeHeadLine(T var1) throws IOException;

   public void write(T message) throws IOException, HttpException {
      Args.notNull(message, "HTTP message");
      this.writeHeadLine(message);
      HeaderIterator it = message.headerIterator();

      while(it.hasNext()) {
         Header header = it.nextHeader();
         this.sessionBuffer.writeLine(this.lineFormatter.formatHeader(this.lineBuf, header));
      }

      this.lineBuf.clear();
      this.sessionBuffer.writeLine(this.lineBuf);
   }
}
