package org.chenyang.http.impl.io;

import org.chenyang.http.HttpRequest;
import org.chenyang.http.io.SessionOutputBuffer;
import org.chenyang.http.message.LineFormatter;
import java.io.IOException;

public class DefaultHttpRequestWriter extends AbstractMessageWriter<HttpRequest> {
   public DefaultHttpRequestWriter(SessionOutputBuffer buffer, LineFormatter formatter) {
      super(buffer, formatter);
   }

   public DefaultHttpRequestWriter(SessionOutputBuffer buffer) {
      this(buffer, (LineFormatter)null);
   }

   protected void writeHeadLine(HttpRequest message) throws IOException {
      this.lineFormatter.formatRequestLine(this.lineBuf, message.getRequestLine());
      this.sessionBuffer.writeLine(this.lineBuf);
   }
}
