package org.chenyang.http.impl.io;

import org.chenyang.http.HttpRequest;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.io.HttpMessageWriter;
import org.chenyang.http.io.HttpMessageWriterFactory;
import org.chenyang.http.io.SessionOutputBuffer;
import org.chenyang.http.message.BasicLineFormatter;
import org.chenyang.http.message.LineFormatter;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE_CONDITIONAL
)
public class DefaultHttpRequestWriterFactory implements HttpMessageWriterFactory<HttpRequest> {
   public static final DefaultHttpRequestWriterFactory INSTANCE = new DefaultHttpRequestWriterFactory();
   private final LineFormatter lineFormatter;

   public DefaultHttpRequestWriterFactory(LineFormatter lineFormatter) {
      this.lineFormatter = (LineFormatter)(lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE);
   }

   public DefaultHttpRequestWriterFactory() {
      this((LineFormatter)null);
   }

   public HttpMessageWriter<HttpRequest> create(SessionOutputBuffer buffer) {
      return new DefaultHttpRequestWriter(buffer, this.lineFormatter);
   }
}
