package org.chenyang.http.impl.io;

import org.chenyang.http.HttpResponse;
import org.chenyang.http.HttpResponseFactory;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.config.MessageConstraints;
import org.chenyang.http.impl.DefaultHttpResponseFactory;
import org.chenyang.http.io.HttpMessageParser;
import org.chenyang.http.io.HttpMessageParserFactory;
import org.chenyang.http.io.SessionInputBuffer;
import org.chenyang.http.message.BasicLineParser;
import org.chenyang.http.message.LineParser;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE_CONDITIONAL
)
public class DefaultHttpResponseParserFactory implements HttpMessageParserFactory<HttpResponse> {
   public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
   private final LineParser lineParser;
   private final HttpResponseFactory responseFactory;

   public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
      this.lineParser = (LineParser)(lineParser != null ? lineParser : BasicLineParser.INSTANCE);
      this.responseFactory = (HttpResponseFactory)(responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE);
   }

   public DefaultHttpResponseParserFactory() {
      this((LineParser)null, (HttpResponseFactory)null);
   }

   public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
      return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
   }
}
