package org.chenyang.http.impl.io;

import org.chenyang.http.HttpResponse;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.io.HttpMessageWriter;
import org.chenyang.http.io.HttpMessageWriterFactory;
import org.chenyang.http.io.SessionOutputBuffer;
import org.chenyang.http.message.BasicLineFormatter;
import org.chenyang.http.message.LineFormatter;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE_CONDITIONAL
)
public class DefaultHttpResponseWriterFactory implements HttpMessageWriterFactory<HttpResponse> {
   public static final DefaultHttpResponseWriterFactory INSTANCE = new DefaultHttpResponseWriterFactory();
   private final LineFormatter lineFormatter;

   public DefaultHttpResponseWriterFactory(LineFormatter lineFormatter) {
      this.lineFormatter = (LineFormatter)(lineFormatter != null ? lineFormatter : BasicLineFormatter.INSTANCE);
   }

   public DefaultHttpResponseWriterFactory() {
      this((LineFormatter)null);
   }

   public HttpMessageWriter<HttpResponse> create(SessionOutputBuffer buffer) {
      return new DefaultHttpResponseWriter(buffer, this.lineFormatter);
   }
}
