package org.chenyang.http.impl.pool;

import org.chenyang.http.HttpClientConnection;
import org.chenyang.http.HttpHost;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.config.ConnectionConfig;
import org.chenyang.http.config.SocketConfig;
import org.chenyang.http.params.HttpParams;
import org.chenyang.http.pool.AbstractConnPool;
import org.chenyang.http.pool.ConnFactory;
import java.util.concurrent.atomic.AtomicLong;

@Contract(
   threading = ThreadingBehavior.SAFE_CONDITIONAL
)
public class BasicConnPool extends AbstractConnPool<HttpHost, HttpClientConnection, BasicPoolEntry> {
   private static final AtomicLong COUNTER = new AtomicLong();

   public BasicConnPool(ConnFactory<HttpHost, HttpClientConnection> connFactory) {
      super(connFactory, 2, 20);
   }

   /** @deprecated */
   @Deprecated
   public BasicConnPool(HttpParams params) {
      super(new BasicConnFactory(params), 2, 20);
   }

   public BasicConnPool(SocketConfig sconfig, ConnectionConfig cconfig) {
      super(new BasicConnFactory(sconfig, cconfig), 2, 20);
   }

   public BasicConnPool() {
      super(new BasicConnFactory(SocketConfig.DEFAULT, ConnectionConfig.DEFAULT), 2, 20);
   }

   protected BasicPoolEntry createEntry(HttpHost host, HttpClientConnection conn) {
      return new BasicPoolEntry(Long.toString(COUNTER.getAndIncrement()), host, conn);
   }

   protected boolean validate(BasicPoolEntry entry) {
      return !((HttpClientConnection)entry.getConnection()).isStale();
   }
}
