package org.chenyang.http.message;

import org.chenyang.http.FormattedHeader;
import org.chenyang.http.HeaderElement;
import org.chenyang.http.ParseException;
import org.chenyang.http.util.Args;
import org.chenyang.http.util.CharArrayBuffer;
import java.io.Serializable;

public class BufferedHeader implements FormattedHeader, Cloneable, Serializable {
   private static final long serialVersionUID = -2768352615787625448L;
   private final String name;
   private final CharArrayBuffer buffer;
   private final int valuePos;

   public BufferedHeader(CharArrayBuffer buffer) throws ParseException {
      Args.notNull(buffer, "Char array buffer");
      int colon = buffer.indexOf(58);
      if (colon == -1) {
         throw new ParseException("Invalid header: " + buffer.toString());
      } else {
         String s = buffer.substringTrimmed(0, colon);
         if (s.isEmpty()) {
            throw new ParseException("Invalid header: " + buffer.toString());
         } else {
            this.buffer = buffer;
            this.name = s;
            this.valuePos = colon + 1;
         }
      }
   }

   public String getName() {
      return this.name;
   }

   public String getValue() {
      return this.buffer.substringTrimmed(this.valuePos, this.buffer.length());
   }

   public HeaderElement[] getElements() throws ParseException {
      ParserCursor cursor = new ParserCursor(0, this.buffer.length());
      cursor.updatePos(this.valuePos);
      return BasicHeaderValueParser.INSTANCE.parseElements(this.buffer, cursor);
   }

   public int getValuePos() {
      return this.valuePos;
   }

   public CharArrayBuffer getBuffer() {
      return this.buffer;
   }

   public String toString() {
      return this.buffer.toString();
   }

   public Object clone() throws CloneNotSupportedException {
      return super.clone();
   }
}
