package org.chenyang.http.protocol;

import org.chenyang.http.HttpException;
import org.chenyang.http.HttpResponse;
import org.chenyang.http.HttpResponseInterceptor;
import org.chenyang.http.annotation.Contract;
import org.chenyang.http.annotation.ThreadingBehavior;
import org.chenyang.http.util.Args;
import java.io.IOException;

@Contract(
   threading = ThreadingBehavior.IMMUTABLE
)
public class ResponseServer implements HttpResponseInterceptor {
   private final String originServer;

   public ResponseServer(String originServer) {
      this.originServer = originServer;
   }

   public ResponseServer() {
      this(null);
   }

   public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
      Args.notNull(response, "HTTP response");
      if (!response.containsHeader("Server") && this.originServer != null) {
         response.addHeader("Server", this.originServer);
      }

   }
}
