package util.sqlparse;

import bean.Column;
import bean.DataBase;
import bean.Schema;
import bean.Table;
import com.chenyang.druid.sql.dialect.es.ast.EsParserContextBase;
import com.chenyang.druid.sql.dialect.es.visitor.ESOutputVisitor;
import com.chenyang.druid.sql.dialect.es.visitor.Printer;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.sqlparse.visitor.es.ApiParser;
import util.sqlparse.visitor.es.dense.Desensitizor;
import util.sqlparse.visitor.es.memo.ApiResult;
import util.sqlparse.visitor.es.memo.FieldMemo;
import util.sqlparse.visitor.es.memo.IndexMemo;
import util.sqlparse.visitor.es.memo.MappingMemo;

public class ElasticSearchParse {
   public static final String VERSION = "v7.16";
   private List<Column> columnList = new ArrayList();
   private Map<String, String> tableMap = new HashMap();
   private Map<String, String> schemaMap = new HashMap();
   private Map<String, String> whereMap = new HashMap();
   private List whereList = new ArrayList();
   public Map<String, String> params;

   public ElasticSearchParse() {
   }

   public ElasticSearchParse(Map<String, String> params) {
      this.params = params;
   }

   public String parseSql() {
      return null;
   }

   public void parseSqlStructure(Map<String, Object> paramMap) throws SQLException {
      System.out.println("传入的参数：=========================================>" + this.params);
      String request = (String)this.params.get("sql");
      DataBase dataBase = this.getDataBase();
      ApiParser parser = new ApiParser();
      List<Schema> schemas = new ArrayList();
      HashMap<String, HashMap> schemaMap1 = new HashMap();

      try {
         ApiResult result = parser.parse(request, dataBase);
         paramMap.put("sql", result.getStatement().toString());
         paramMap.put("stmtType", result.stmtType);
         paramMap.put("apiType", result.apiType);
         paramMap.put("parseTree", result.getStatement());
         paramMap.put("type", result.apiType.toString().toUpperCase());
         List<IndexMemo> indices = result.getSchemas();
         if (indices != null && indices.size() > 0) {
            for(IndexMemo index : indices) {
               this.schemaMap.put(index.name, index.name);
               schemaMap1.put(index.name, new HashMap());
            }
         }

         List<MappingMemo> tables = result.getTables();
         if (tables != null && tables.size() > 0) {
            for(MappingMemo table : tables) {
               this.tableMap.put(table.name, table.name);
               HashMap schema111 = (HashMap)schemaMap1.get(table.index.name);
               schema111.put(table.name, new HashMap());
            }
         }

         List<FieldMemo> fields = result.getFields();
         if (fields != null) {
            for(FieldMemo field : fields) {
               Column column = new Column();
               column.setColumnName(field.name);
               column.setDataType(field.dataType);
               if (field.index != null) {
                  column.setTable(field.mapping.name);
                  column.setSchema(field.index.name);
               }

               this.columnList.add(column);
               if (schemaMap1.get(field.index.name) == null) {
                  schemaMap1.put(field.index.name, new HashMap());
               } else {
                  HashMap<String, HashMap> mappingmap1 = (HashMap)schemaMap1.get(field.index.name);
                  if (mappingmap1.get(field.mapping.name) == null) {
                     mappingmap1.put(field.mapping.name, new HashMap());
                  } else {
                     HashMap<String, String> fieldSet = (HashMap)mappingmap1.get(field.mapping.name);
                     fieldSet.put(field.name, field.dataType);
                  }
               }
            }
         }
      } catch (MalformedURLException e) {
         e.printStackTrace();
         throw new SQLException(e);
      }

      for(String key : schemaMap1.keySet()) {
         Schema schema = new Schema(key);
         HashMap<String, HashMap> mappingm = (HashMap)schemaMap1.get(key);
         List<Table> tableList = new ArrayList();

         for(String key1 : mappingm.keySet()) {
            Table table = new Table(key1, key);
            HashMap<String, String> fieldM = (HashMap)mappingm.get(key1);
            List<Column> columnList = new ArrayList();

            for(String f : fieldM.keySet()) {
               Column column = new Column(f, key, key1, (String)fieldM.get(f));
               columnList.add(column);
            }

            table.setColumnList(columnList);
            tableList.add(table);
         }

         schema.setTableList(tableList);
         schemas.add(schema);
      }

      paramMap.put("schemaList", schemas);
      paramMap.put("schemaMap", this.schemaMap);
      paramMap.put("whereMap", this.whereMap);
      paramMap.put("whereList", this.whereList);
      paramMap.put("tableMap", this.tableMap);
      paramMap.put("columnList", this.columnList);
   }

   public String parseSql_table() {
      String request = (String)this.params.get("sql");
      ApiParser parser = new ApiParser();

      try {
         DataBase database = this.getDataBase();
         ApiResult result = parser.parse(request, database);
         EsParserContextBase statement = result.getStatement();
         result.database = database;
         Map map = new HashMap(this.params);
         map.put("apiResult", result);
         this.denseTable(map);
         Object isMatched = map.get("isMatched");
         if (isMatched != null) {
            this.params.put("isMatched", isMatched.toString());
         }

         ESOutputVisitor visitor = new ESOutputVisitor();
         Printer printer = visitor.visit(statement);
         return printer.toString();
      } catch (MalformedURLException e) {
         e.printStackTrace();
         return null;
      }
   }

   public String parseSql_column() {
      String request = (String)this.params.get("sql");
      ApiParser parser = new ApiParser();

      try {
         DataBase database = this.getDataBase();
         ApiResult result = parser.parse(request, database);
         EsParserContextBase statement = result.getStatement();
         result.database = database;
         Map map = new HashMap(this.params);
         map.put("apiResult", result);
         this.denseColumn(map);
         String data = (String)map.get("esResponseBytes");
         return data;
      } catch (MalformedURLException e) {
         e.printStackTrace();
         return null;
      }
   }

   public String parseSql_data() {
      String request = (String)this.params.get("sql");
      ApiParser parser = new ApiParser();

      try {
         DataBase database = this.getDataBase();
         ApiResult result = parser.parse(request, database);
         EsParserContextBase statement = result.getStatement();
         result.database = database;
         Map map = new HashMap(this.params);
         map.put("apiResult", result);
         this.denseData(map);
         String data = (String)map.get("esResponseBytes");
         return data;
      } catch (MalformedURLException e) {
         e.printStackTrace();
         return null;
      }
   }

   public String rowVisitControl(Map<String, Object> param) throws SQLException {
      String request = (String)param.get("sql");
      ApiParser parser = new ApiParser();

      try {
         DataBase database = this.getDataBase(param);
         ApiResult result = parser.parse(request, database);
         EsParserContextBase statement = result.getStatement();
         result.database = database;
         Map map = new HashMap(param);
         map.put("apiResult", result);
         this.denseRow(map);
         Object isMatched = map.get("isMatched");
         if (isMatched != null) {
            param.put("isMatched", isMatched);
         }

         ESOutputVisitor visitor = new ESOutputVisitor();
         Printer printer = visitor.visit(statement);
         return printer.toString();
      } catch (MalformedURLException e) {
         e.printStackTrace();
         return null;
      }
   }

   private void denseTable(Map map) {
      Desensitizor.tableDense(map);
   }

   private void denseColumn(Map map) {
      Desensitizor.columnDense(map);
   }

   private void denseData(Map map) {
      Desensitizor.dataDense(map);
   }

   private void denseRow(Map map) {
      Desensitizor.rowDense(map);
   }

   private DataBase getDataBase() {
      String url = (String)this.params.get("url");
      DataBase dataBase = null;

      for(DataBase db : JdbcUtil.dataBaseList) {
         if (url.equalsIgnoreCase(db.getUrl())) {
            dataBase = db;
            break;
         }
      }

      return dataBase;
   }

   private DataBase getDataBase(Map param) {
      String url = (String)param.get("url");
      DataBase dataBase = null;

      for(DataBase db : JdbcUtil.dataBaseList) {
         if (url.equalsIgnoreCase(db.getUrl())) {
            dataBase = db;
            break;
         }
      }

      return dataBase;
   }

   public List<String> parseWheres(String request) {
      ApiParser parser = new ApiParser();
      return parser.where(request);
   }
}
