package util.sqlparse.visitor.es.dense.data.query;

import com.chenyang.druid.sql.dialect.es.ast.EsParser;
import util.sqlparse.visitor.es.dense.Denseable;
import util.sqlparse.visitor.es.dense.ParamContext;
import util.sqlparse.visitor.es.memo.ApiResult;
import util.sqlparse.visitor.es.memo.FlowType;

public class QueryDataStatementTermsEnumDense extends Denseable {
   @FlowType(FlowType.FlowTypeValue.up)
   public void denseTable(ParamContext.TableDenseContext params) {
      ApiResult api = params.getApi();
      EsParser.StatementContext statement = (EsParser.StatementContext)api.getStatement();
      EsParser.QueryDataStatementContext stmt = statement.queryDataStatement();
      if (stmt != null) {
         EsParser.QueryDataStatementTermsEnumContext terms = stmt.queryDataStatementTermsEnum();
         if (terms != null) {
            super.denseTable(params);
         }
      }
   }

   @FlowType(FlowType.FlowTypeValue.down)
   public void denseColumn(ParamContext.ColumnDenseContext params) {
   }

   @FlowType(FlowType.FlowTypeValue.down)
   public void denseData(ParamContext.DenseAllContext params) {
      this.denseColumn(new ParamContext.ColumnDenseContext(params));
   }

   @FlowType(FlowType.FlowTypeValue.none)
   public void denseRow(ParamContext.RowDenseContext params) {
   }
}
