package util.sqlparse.visitor.es.dense.test;

import bean.DataBase;
import com.chenyang.druid.sql.dialect.es.ast.EsParserContextBase;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import util.JdbcUtil;
import util.sqlparse.visitor.es.ApiParser;
import util.sqlparse.visitor.es.dense.ParamContext;
import util.sqlparse.visitor.es.dense.data.query.MSearchDense;
import util.sqlparse.visitor.es.memo.ApiResult;

public class TestMSearchDense {
   public static void main(String[] args) throws MalformedURLException {
      Map<String, Object> params = new HashMap();
      params.put("sql", null);
      params.put("dbType", "es");
      params.put("url", "http://192.168.2.229:9200");
      params.put("uri", "/_search");
      params.put("method", "get");
      params.put("replaceSchema", "emp");
      params.put("replaceNewTable", "man1");
      params.put("replaceTable", ".*man.*");
      params.put("replaceColumn", "name1");
      params.put("expression", "concat(substr(${value},1,1),'**')");
      params.put("configPath", "D:/masking-mysql.properties");
      String content = "{\n      \"ip_port\": \"192.168.2.229:9200\",\n      \"url\": \"http://192.168.2.229:9200\",\n      \"username\": \"test1\",\n      \"password\": \"123456\",\n      \"dbType\": \"es\",\n      \"excludeSchema\": []\n    }";
      JdbcUtil.initData(content);

      try {
         Thread.sleep(2000L);
      } catch (InterruptedException e) {
         e.printStackTrace();
      }

      String url = "http://192.168.2.229:9200";
      DataBase dataBase = null;

      for(DataBase db : JdbcUtil.dataBaseList) {
         if (url.equalsIgnoreCase(db.getUrl())) {
            dataBase = db;
            break;
         }
      }

      testDenseRow(params, dataBase);
   }

   static void testDenseTable(Map<String, Object> params, DataBase dataBase) throws MalformedURLException {
      String[] datas = new String[]{"get /emp/_msearch\n{}{}{\"type\": \"man*\"}\n{}{\"index\": \"emp*\"}\n{}{\"index\": \"emp*\",\"type\":\"man\"}\n{\"query\" : {\"match_all\" : {}}}\n"};

      for(String data : datas) {
         ApiParser parser = new ApiParser();
         ApiResult result = parser.parse(data, dataBase);
         params.put("apiResult", result);
         EsParserContextBase statement = result.getStatement();
         ParamContext.TableDenseContext tableCtx = new ParamContext.TableDenseContext(params);
         MSearchDense dense = new MSearchDense();
         dense.denseTable(tableCtx);
         System.out.println(statement.toString());
      }

   }

   static void testDenseColumn(Map<String, Object> params, DataBase dataBase) throws MalformedURLException {
      String[] datas = new String[]{"get /emp/_msearch\n{}{}{\"type\": \"man*\"}\n{}{\"index\": \"emp*\"}\n{}{\"index\": \"emp*\",\"type\":\"man\"}\n{\"query\" : {\"match_all\" : {}}}\n"};

      for(String data : datas) {
         ApiParser parser = new ApiParser();
         ApiResult result = parser.parse(data, dataBase);
         EsParserContextBase statement = result.getStatement();
         ParamContext.ColumnDenseContext colCtx = new ParamContext.ColumnDenseContext(params);
         MSearchDense dense = new MSearchDense();
         dense.denseColumn(colCtx);
         System.out.println(statement.toString());
      }

   }

   static void testDenseRow(Map<String, Object> params, DataBase dataBase) throws MalformedURLException {
      String[] datas = new String[]{"get /emp/_msearch\n{}{}{\"type\": \"man*\"}\n{}{\"index\": \"emp*\"}\n{}{\"index\": \"emp*\",\"type\":\"man\"}\n{\"query\" : {\"match_all\" : {}}}\n"};
      Map<String, List<String>> modifyTable = new HashMap();
      Map<String, String> tableKeyWord = new HashMap();
      modifyTable.put("basic-info.name", Arrays.asList("and"));
      tableKeyWord.put("man", "basic-info.name");
      params.put("modifyTable", modifyTable);
      params.put("tableKeyWord", tableKeyWord);
      params.put("operateType", "select");

      for(String data : datas) {
         ApiParser parser = new ApiParser();
         ApiResult result = parser.parse(data, dataBase);
         params.put("apiResult", result);
         EsParserContextBase statement = result.getStatement();
         ParamContext.RowDenseContext rowCtx = new ParamContext.RowDenseContext(params);
         MSearchDense dense = new MSearchDense();
         dense.denseRow(rowCtx);
         System.out.println(statement.toString());
      }

   }
}
