package util.sqlparse.visitor.es.visitor;

import com.chenyang.druid.sql.dialect.es.ast.EsParser;
import com.chenyang.druid.sql.dialect.es.ast.EsParserBaseVisitor;
import com.chenyang.druid.sql.dialect.es.ast.EsParserContextBase;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import util.StringJoin;
import util.sqlparse.visitor.es.api.RequestBuilder;

public class ScopeVisitor extends EsParserBaseVisitor<Scope> {
   private Scope scope;
   public List<EsParserContextBase> values = new ArrayList();
   public List<EsParserContextBase> fields = new ArrayList();
   public List<EsParserContextBase> indices = new ArrayList();
   public List<EsParserContextBase> mappings = new ArrayList();

   public ScopeVisitor(Scope scope) {
      this.scope = scope;
   }

   public Scope visitStatement(EsParser.StatementContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitOtherStatement(final EsParser.OtherStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitCreateIndexStatement(final EsParser.CreateIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.createIndexStatementBody());
         }
      });
   }

   public Scope visitCreateIndexStatementBody(EsParser.CreateIndexStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCreateIndexStatementMappings(EsParser.CreateIndexStatementMappingsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCreateIndexStatementMappingsType(EsParser.CreateIndexStatementMappingsTypeContext ctx) {
      if (ctx.mappingName != null) {
         this.setMappingString(ctx.mappingName);
      }

      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUpdateIndexStatement(final EsParser.UpdateIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ctx.updateMappingStatementBody().accept(ScopeVisitor.this);
         }
      });
   }

   public Scope visitUpdateMappingStatementBody(EsParser.UpdateMappingStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDeleteIndexStatement(final EsParser.DeleteIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitCloseIndexStatement(final EsParser.CloseIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.CLOSE()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitOpenIndexStatement(final EsParser.OpenIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.OPEN()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitShrinkIndexStatement(final EsParser.ShrinkIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.SHRINK()).path(ctx.shrinkIndexName).index(ctx.indexName).index(ctx.shrinkIndexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitCloneIndexStatement(final EsParser.CloneIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.CLONE()).path(ctx.cloneIndexName).index(ctx.indexName).index(ctx.cloneIndexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitRolloverIndexStatement(final EsParser.RolloverIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.ROLLOVER()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitUnfreezeIndexStatement(final EsParser.UnfreezeIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.UNFREEZE()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitFreezeIndexStatement(final EsParser.FreezeIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.FREEZE()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitResloveIndexStatement(final EsParser.ResloveIndexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.RESLOVE()).path(ctx.indexName).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitQueryDataRenderStatement(final EsParser.QueryDataRenderStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.RENDER()).path(ctx.uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitQueryDataSearchShardsStatement(final EsParser.QueryDataSearchShardsStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.SEARCH_SHARDS()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitDdlMappingProperties(EsParser.DdlMappingPropertiesContext ctx) {
      return this.scopeVisit(ctx);
   }

   public Scope visitDdlMappingPropertiesDefine(EsParser.DdlMappingPropertiesDefineContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDdlFieldDecl(EsParser.DdlFieldDeclContext ctx) {
      this.setFieldString(ctx.fieldName);
      return this.visit((ParseTree)ctx.ddlField());
   }

   public Scope visitDdlField(EsParser.DdlFieldContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDdlFieldType(EsParser.DdlFieldTypeContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQuerySchemaStatement(EsParser.QuerySchemaStatementContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQuerySchemaStatementALL(final EsParser.QuerySchemaStatementALLContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.MAPPING1()).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitQuerySchemaStatementIndex(final EsParser.QuerySchemaStatementIndexContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.MAPPING1()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitBulkStatement(final EsParser.BulkStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.BULK()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit(ctx.bulkStatementBody());
         }
      });
   }

   public Scope visitBulkStatementBody(EsParser.BulkStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementCreate(EsParser.BulkStatementCreateContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementDelete(EsParser.BulkStatementDeleteContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementIndex(EsParser.BulkStatementIndexContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementUpdate(EsParser.BulkStatementUpdateContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementDoc(EsParser.BulkStatementDocContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementDocItemField(EsParser.BulkStatementDocItemFieldContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindValueFields(ctx.fieldValue, (List)ctx.fields);
      return this.scope;
   }

   public Scope visitBulkStatementFields(EsParser.BulkStatementFieldsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementScript(EsParser.BulkStatementScriptContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBulkStatementIndexPart(EsParser.BulkStatementIndexPartContext ctx) {
      this.setIndexString(ctx.indexName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatement(EsParser.QueryDataStatementContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementById(final EsParser.QueryDataStatementByIdContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriSeg()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementSearchBody());
         }
      });
   }

   public Scope visitQueryDataStatementMGET(final EsParser.QueryDataStatementMGETContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.mappingName).path(ctx.MGET()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementMGETBody());
         }
      });
   }

   public Scope visitQueryDataStatementMGETBody(EsParser.QueryDataStatementMGETBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocs(EsParser.QueryDataStatementMGETDocsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDoc(EsParser.QueryDataStatementMGETDocContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocIndex(EsParser.QueryDataStatementMGETDocIndexContext ctx) {
      this.setIndexString(ctx.indexName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocType(EsParser.QueryDataStatementMGETDocTypeContext ctx) {
      this.setMappingString(ctx.mappingName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocSource(EsParser.QueryDataStatementMGETDocSourceContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocSourceBoolean(EsParser.QueryDataStatementMGETDocSourceBooleanContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocSourceArr(EsParser.QueryDataStatementMGETDocSourceArrContext ctx) {
      this.setFieldString(ctx.stringArr());
      return this.scope;
   }

   public Scope visitQueryDataStatementMGETDocSourceObj(EsParser.QueryDataStatementMGETDocSourceObjContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMGETDocIncldue(EsParser.QueryDataStatementMGETDocIncldueContext ctx) {
      this.setIndexStrings(ctx.stringArr());
      return this.scope;
   }

   public Scope visitQueryDataStatementMGETDocExclude(EsParser.QueryDataStatementMGETDocExcludeContext ctx) {
      this.setIndexStrings(ctx.stringArr());
      return this.scope;
   }

   public Scope visitQueryDataStatementMGETStoredFields(EsParser.QueryDataStatementMGETStoredFieldsContext ctx) {
      this.setIndexStrings(ctx.stringArr());
      return this.scope;
   }

   public Scope visitQueryDataStatementMGETIds(EsParser.QueryDataStatementMGETIdsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMSearch(final EsParser.QueryDataStatementMSearchContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.mappingName).path(ctx.MSEARCH()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementMSearchBody());
         }
      });
   }

   public Scope visitQueryDataStatementMSearchBody(EsParser.QueryDataStatementMSearchBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementMSearchEmpty(EsParser.QueryDataStatementMSearchEmptyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementCount(final EsParser.QueryDataStatementCountContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.COUNT()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementCountBody());
         }
      });
   }

   public Scope visitQueryDataStatementCountBody(EsParser.QueryDataStatementCountBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementTermsEnum(final EsParser.QueryDataStatementTermsEnumContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.TERMS_ENUM()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementTermsEnumBody());
         }
      });
   }

   public Scope visitQueryDataStatementTermsEnumBody(EsParser.QueryDataStatementTermsEnumBodyContext ctx) {
      this.bindContext(ctx);
      return this.scope;
   }

   public Scope visitQueryDataStatementTermsEnumField(EsParser.QueryDataStatementTermsEnumFieldContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitQueryDataStatementTermsEnumValue(EsParser.QueryDataStatementTermsEnumValueContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementExplain(final EsParser.QueryDataStatementExplainContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.EXPLAIN()).path(ctx.id).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementExplainBody());
         }
      });
   }

   public Scope visitQueryDataStatementExplainBody(EsParser.QueryDataStatementExplainBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementFieldCaps(final EsParser.QueryDataStatementFieldCapsContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.FIELD_CAPS()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementFieldCapsBody());
         }
      });
   }

   public Scope visitQueryDataStatementFieldCapsBody(EsParser.QueryDataStatementFieldCapsBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementFieldCapsBodyIndexFiter(EsParser.QueryDataStatementFieldCapsBodyIndexFiterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEval(final EsParser.QueryDataStatementRankEvalContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.RANK_EVAL()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementRankEvalBody());
         }
      });
   }

   public Scope visitQueryDataStatementRankEvalBody(EsParser.QueryDataStatementRankEvalBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRequests(EsParser.QueryDataStatementRankEvalRequestsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRequestBody(EsParser.QueryDataStatementRankEvalRequestBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRequest(EsParser.QueryDataStatementRankEvalRequestContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRatings(EsParser.QueryDataStatementRankEvalRatingsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRating(EsParser.QueryDataStatementRankEvalRatingContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRatingIndex(EsParser.QueryDataStatementRankEvalRatingIndexContext ctx) {
      this.setIndexString(ctx.indexName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementRankEvalRatingId(EsParser.QueryDataStatementRankEvalRatingIdContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearch(final EsParser.QueryDataStatementSearchContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.SEARCH()).path(ctx.ASYNC_SEARCH()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryDataStatementSearchBody());
         }
      });
   }

   public Scope visitQueryDataStatementSearchBody(EsParser.QueryDataStatementSearchBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyDocValueFields(EsParser.QueryDataStatementSearchBodyDocValueFieldsContext ctx) {
      this.enterScope(ctx);
      EsParser.FieldExprContext fieldExprContext = ctx.fieldExpr();
      if (fieldExprContext != null) {
         fieldExprContext.supportRegex = true;
      }

      this.exitScope();
      return this.scope;
   }

   public Scope visitFieldExpr(EsParser.FieldExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitField(EsParser.FieldContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldString(EsParser.FieldStringContext ctx) {
      this.setFieldString(ctx.fieldName);
      return this.scope;
   }

   public Scope visitFieldObj(EsParser.FieldObjContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyStoredFields(EsParser.QueryDataStatementSearchBodyStoredFieldsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyIndicesBoostItem(EsParser.QueryDataStatementSearchBodyIndicesBoostItemContext ctx) {
      this.setIndexString(ctx.indexName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyIndexTypes(EsParser.QueryDataStatementSearchBodyIndexTypesContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyIndex(EsParser.QueryDataStatementSearchBodyIndexContext ctx) {
      this.setIndexStrings(ctx.indexNames);
      this.setIndexString(ctx.indexName);
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodyType(EsParser.QueryDataStatementSearchBodyTypeContext ctx) {
      this.setMappingString(ctx.mappingName);
      this.setMappingStrings(ctx.mappingNames);
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodyRuntimeMappings(EsParser.QueryDataStatementSearchBodyRuntimeMappingsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyRuntimeMappingObj(EsParser.QueryDataStatementSearchBodyRuntimeMappingObjContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyRuntimeMappingObjFieldExpr(EsParser.QueryDataStatementSearchBodyRuntimeMappingObjFieldExprContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodyRuntimeMappingsArr(EsParser.QueryDataStatementSearchBodyRuntimeMappingsArrContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRunTimeMappingFieldExprs(EsParser.RunTimeMappingFieldExprsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRuntimeMappingField(EsParser.RuntimeMappingFieldContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodyQuery(EsParser.QueryDataStatementSearchBodyQueryContext ctx) {
      this.enterScope(ctx);
      this.visitChildren(ctx);
      this.exitScope();
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodyFields(EsParser.QueryDataStatementSearchBodyFieldsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchBodyAgg(EsParser.QueryDataStatementSearchBodyAggContext ctx) {
      this.enterScope(ctx);
      this.visitChildren(ctx);
      this.exitScope();
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodyAggBody(EsParser.QueryDataStatementSearchBodyAggBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryDataStatementSearchSort(EsParser.QueryDataStatementSearchSortContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSortField(EsParser.SortFieldContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitQueryDataStatementSearchBodySource(EsParser.QueryDataStatementSearchBodySourceContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSourceFieldExpr(EsParser.SourceFieldExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSourceFieldBoolenExpr(EsParser.SourceFieldBoolenExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSourceFieldWildcardPatternExpr(EsParser.SourceFieldWildcardPatternExprContext ctx) {
      this.setFieldString(ctx.fieldName, true);
      this.setFieldString(ctx.fieldNames, true);
      return this.scope;
   }

   public Scope visitSourceFieldObjectExpr(EsParser.SourceFieldObjectExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSourceFieldIncludeExpr(EsParser.SourceFieldIncludeExprContext ctx) {
      this.setFieldString(ctx.fieldNames, true);
      this.setFieldString(ctx.fieldName, true);
      return this.scope;
   }

   public Scope visitSourceFieldExcludeExpr(EsParser.SourceFieldExcludeExprContext ctx) {
      this.setFieldString(ctx.fieldNames, true);
      this.setFieldString(ctx.fieldName, true);
      return this.scope;
   }

   public Scope visitInsertDataStatement(EsParser.InsertDataStatementContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitInsertDataStatementForm1(final EsParser.InsertDataStatementForm1Context ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.CREATE()).path(ctx.id).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.cuDataStatementBody());
         }
      });
   }

   public Scope visitInsertDataStatementForm2(final EsParser.InsertDataStatementForm2Context ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriSeg()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.cuDataStatementBody());
         }
      });
   }

   public Scope visitUpdateDataStatement(EsParser.UpdateDataStatementContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUpdateDataStatementById(EsParser.UpdateDataStatementByIdContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUpdateDataStatementPart1(final EsParser.UpdateDataStatementPart1Context ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.UPDATE()).path(ctx.id).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.cuDataStatementBody());
         }
      });
   }

   public Scope visitUpdateDataStatementPart2(final EsParser.UpdateDataStatementPart2Context ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriSeg()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.cuDataStatementBody());
         }
      });
   }

   public Scope visitUpdateDataStatementByQuery(final EsParser.UpdateDataStatementByQueryContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.UPDATE_BY_QUERY()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.updateDataStatementByQueryBody());
         }
      });
   }

   public Scope visitDeleteDataStatement(EsParser.DeleteDataStatementContext ctx) {
      return this.scopeVisit(ctx);
   }

   public Scope visitDeleteDataByIdStatement(final EsParser.DeleteDataByIdStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriSeg()).index(ctx.indexName).mapping(ctx.mappingName).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitDeleteDataByQueryStatement(final EsParser.DeleteDataByQueryStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.DELETE_BY_QUERY()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.queryBody());
         }
      });
   }

   public Scope visitCuDataStatementBody(EsParser.CuDataStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCuDataStatementValue(EsParser.CuDataStatementValueContext ctx) {
      System.out.println("");
      List<FieldItem> fds = new ArrayList();
      this.visitFields(ctx, new ArrayList(), new ArrayList(), fds);

      for(FieldItem field : fds) {
         if (!this.fields.contains(field.ctx)) {
            this.fields.add(field.ctx);
         }
      }

      return this.scope;
   }

   public Scope visitCuDataStatementObjValue(EsParser.CuDataStatementObjValueContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCuDataStatementArrayValue(EsParser.CuDataStatementArrayValueContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCuDataStatementObjValuePair(EsParser.CuDataStatementObjValuePairContext ctx) {
      this.setFieldString(ctx.string());
      this.visitObjectRuleContextList(Arrays.asList(ctx.cuDataStatementFieldScript(), ctx.cuDataStatementValue()));
      return this.scope;
   }

   public Scope visitCuDataStatementFieldScript(EsParser.CuDataStatementFieldScriptContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitQueryBody(EsParser.QueryBodyContext ctx) {
      Scope scope = new Scope(ctx);
      this.scope.enterScope(scope);
      this.visitChildren(ctx);
      this.scope.exitScope();
      return this.scope;
   }

   public Scope visitQueryFilter(EsParser.QueryFilterContext ctx) {
      Scope scope = new Scope(ctx);
      this.scope.enterScope(scope);
      this.visitChildren(ctx);
      this.scope.exitScope();
      return this.scope;
   }

   public Scope visitComboundFilter(EsParser.ComboundFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitNsetedFilter(EsParser.NsetedFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitNsetedFilterItem(EsParser.NsetedFilterItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitNsetedFilterItemPath(EsParser.NsetedFilterItemPathContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBoostingFilter(EsParser.BoostingFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBoostingFilterBody(EsParser.BoostingFilterBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitHasChildFilter(EsParser.HasChildFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitHasParentFilter(EsParser.HasParentFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitParentIdFilter(EsParser.ParentIdFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBoolFilter(EsParser.BoolFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMustFilter(EsParser.MustFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMustFilterN(EsParser.MustFilterNContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMustFilter1(EsParser.MustFilter1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterFilter(EsParser.FilterFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterFilterN(EsParser.FilterFilterNContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterFilter1(EsParser.FilterFilter1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitShouldFilter(EsParser.ShouldFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitShouldFilterN(EsParser.ShouldFilterNContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitShouldFilter1(EsParser.ShouldFilter1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitConstantScoreFilter(EsParser.ConstantScoreFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDismaxFilter(EsParser.DismaxFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDismaxFilterQueriesBody(EsParser.DismaxFilterQueriesBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDismaxFilterQueriesBodyItems(EsParser.DismaxFilterQueriesBodyItemsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFunctionScoreFilter(EsParser.FunctionScoreFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafFilter(EsParser.LeafFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilter(EsParser.IntervalFilterContext ctx) {
      this.setFieldString(ctx.fieldName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleAnyOf(EsParser.IntervalFilterRuleAnyOfContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleAllOf(EsParser.IntervalFilterRuleAllOfContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleMatch(EsParser.IntervalFilterRuleMatchContext ctx) {
      this.bindContext(ctx);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleMatchQuery(EsParser.IntervalFilterRuleMatchQueryContext ctx) {
      this.bindValues(ctx.values);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleMatchUseField(EsParser.IntervalFilterRuleMatchUseFieldContext ctx) {
      this.setFieldString(ctx.fieldName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRulePrefix(EsParser.IntervalFilterRulePrefixContext ctx) {
      this.bindContext(ctx);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRulePrefixPrefix(EsParser.IntervalFilterRulePrefixPrefixContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindValues(ctx.fields, ctx.values);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleWildcard(EsParser.IntervalFilterRuleWildcardContext ctx) {
      this.bindContext(ctx);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleWildcardPattern(EsParser.IntervalFilterRuleWildcardPatternContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindValues(ctx.fields, ctx.values);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleFuzzy(EsParser.IntervalFilterRuleFuzzyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleFilter(EsParser.IntervalFilterRuleFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterRuleInterval(EsParser.IntervalFilterRuleIntervalContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterItem(EsParser.IntervalFilterItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalItem(EsParser.IntervalFilterIntervalItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalRuleAnyOf(EsParser.IntervalFilterIntervalRuleAnyOfContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalRuleAllOf(EsParser.IntervalFilterIntervalRuleAllOfContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalRuleMatch(EsParser.IntervalFilterIntervalRuleMatchContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalRulePrefix(EsParser.IntervalFilterIntervalRulePrefixContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalRuleWildcard(EsParser.IntervalFilterIntervalRuleWildcardContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIntervalFilterIntervalRuleFuzzy(EsParser.IntervalFilterIntervalRuleFuzzyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafMatchAllFilter(EsParser.LeafMatchAllFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafMatchNoneFilter(EsParser.LeafMatchNoneFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafMatchFilter(EsParser.LeafMatchFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterMatch(EsParser.FilterMatchContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterMatchBoolPrefix(EsParser.FilterMatchBoolPrefixContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterMatchPhrase(EsParser.FilterMatchPhraseContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterMatchPhrasePrefix(EsParser.FilterMatchPhrasePrefixContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterCombinedFields(EsParser.FilterCombinedFieldsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterMultiMatch(EsParser.FilterMultiMatchContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterCommon(EsParser.FilterCommonContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterQueryString(EsParser.FilterQueryStringContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterSimpleQueryString(EsParser.FilterSimpleQueryStringContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafTermFilter(EsParser.LeafTermFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterExists(EsParser.FilterExistsContext ctx) {
      this.setFieldString(ctx.fieldName);
      return this.scope;
   }

   public Scope visitFilterFuzzy(EsParser.FilterFuzzyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldFuzzyExactFilter(EsParser.FieldFuzzyExactFilterContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindContext(ctx);
      return this.scope;
   }

   public Scope visitFilterTermFilter(EsParser.FilterTermFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterIds(EsParser.FilterIdsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterPrefix(EsParser.FilterPrefixContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRangeFilter(EsParser.RangeFilterContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindContext(ctx);
      return this.scope;
   }

   public Scope visitRangeFilterGT(EsParser.RangeFilterGTContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRangeFilterLT(EsParser.RangeFilterLTContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRegexpFilter(EsParser.RegexpFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilter(EsParser.TermsFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterField1(EsParser.TermsFilterField1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterFieldN(EsParser.TermsFilterFieldNContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterFieldNItem(EsParser.TermsFilterFieldNItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterField(EsParser.TermsFilterFieldContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterFieldItem1(EsParser.TermsFilterFieldItem1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterFieldItem(EsParser.TermsFilterFieldItemContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindContext(ctx);
      this.visitObjectRuleContextList(Arrays.asList(ctx.termsFilterFieldValueArray(), ctx.termsFilterFieldValueString(), ctx.termsFilterFieldValueLookup()));
      return this.scope;
   }

   public Scope visitTermsFilterFieldValueString(EsParser.TermsFilterFieldValueStringContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterFieldValueArray(EsParser.TermsFilterFieldValueArrayContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsFilterFieldValueLookup(EsParser.TermsFilterFieldValueLookupContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIndexExpr(EsParser.IndexExprContext ctx) {
      this.setIndexString(ctx.indexName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPathExpr(EsParser.PathExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIdExpr(EsParser.IdExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsetFilter(EsParser.TermsetFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsetFilterItem(EsParser.TermsetFilterItemContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.visitObjectRuleContextList(ctx.termsetFilterTerms());
      return this.scope;
   }

   public Scope visitTermsetFilterTerms(EsParser.TermsetFilterTermsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermTypeFilter(EsParser.TermTypeFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitWildcardFilter(EsParser.WildcardFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafGeoFilter(EsParser.LeafGeoFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoBoundingBoxFilter(EsParser.GeoBoundingBoxFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoBoundingBoxFilterField(EsParser.GeoBoundingBoxFilterFieldContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitGeoDistanceFilter(EsParser.GeoDistanceFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoDistanceFilterField(EsParser.GeoDistanceFilterFieldContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoPolygonFilter(EsParser.GeoPolygonFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoPolygonFilterField(EsParser.GeoPolygonFilterFieldContext ctx) {
      this.setFieldString(ctx.fieldName);
      if (ctx.filterValue != null) {
         this.visit((ParseTree)ctx.filterValue);
      }

      return this.scope;
   }

   public Scope visitGeoShapeFilter(EsParser.GeoShapeFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoShapeFilterField(EsParser.GeoShapeFilterFieldContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindValueFields(ctx.fieldValue, ctx.fieldName);
      return this.scope;
   }

   public Scope visitLeafShapeFilter(EsParser.LeafShapeFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitShapeFilter(EsParser.ShapeFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanQuery(EsParser.SpanQueryContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanFilter(EsParser.SpanFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanNearFilter(EsParser.SpanNearFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanNearFilterClausesPart(EsParser.SpanNearFilterClausesPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanNearFilterClausesPartItem(EsParser.SpanNearFilterClausesPartItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanNotFilter(EsParser.SpanNotFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanNotFilterIncludePart(EsParser.SpanNotFilterIncludePartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanNotFilterExcludePart(EsParser.SpanNotFilterExcludePartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanOrFilter(EsParser.SpanOrFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanOrFilterClausesPart(EsParser.SpanOrFilterClausesPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanTermFilter(EsParser.SpanTermFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanWithinFilter(EsParser.SpanWithinFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanWithinFilterPart(EsParser.SpanWithinFilterPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanContainingFilter(EsParser.SpanContainingFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanContainingFilterPart(EsParser.SpanContainingFilterPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanFiledMaskingFilter(EsParser.SpanFiledMaskingFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanFirstFilter(EsParser.SpanFirstFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanFirstFilterPart(EsParser.SpanFirstFilterPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanMultiFilter(EsParser.SpanMultiFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSpanMultiFilterPart(EsParser.SpanMultiFilterPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitLeafOtherFilter(EsParser.LeafOtherFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDistanceFeatureFilter(EsParser.DistanceFeatureFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMoreLikeThisFilter(EsParser.MoreLikeThisFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPercolateFilter(EsParser.PercolateFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRankFeatureFilter(EsParser.RankFeatureFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitScriptFilter(EsParser.ScriptFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitScriptFilterScriptSimple(EsParser.ScriptFilterScriptSimpleContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitScriptFilterSourceValue(EsParser.ScriptFilterSourceValueContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitScriptScoreFilter(EsParser.ScriptScoreFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPinnedFilter(EsParser.PinnedFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPinnedFilterOrganic(EsParser.PinnedFilterOrganicContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPinnedFilterDocs(EsParser.PinnedFilterDocsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPinnedFilterDocsItem(EsParser.PinnedFilterDocsItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPinnedFilterIds(EsParser.PinnedFilterIdsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAggs(EsParser.AggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBucketAggs(EsParser.BucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitReindexStatement(final EsParser.ReindexStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.REINDEX()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.reindexStatementBody());
         }
      });
   }

   public Scope visitReindexStatementBody(EsParser.ReindexStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitReindexStatementSection(EsParser.ReindexStatementSectionContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitReindexStatementSectionIndex(EsParser.ReindexStatementSectionIndexContext ctx) {
      this.setIndexString(ctx.indexName);
      this.setIndexStrings(ctx.indexNames);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermvectorsStatement(EsParser.TermvectorsStatementContext ctx) {
      return this.scopeVisit(ctx);
   }

   public Scope visitTermvectorsStaticStatement(final EsParser.TermvectorsStaticStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.TERMVECTORS()).path(ctx.id).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.termvectorsStatementBody());
         }
      });
   }

   public Scope visitTermvectorsDynamicStatement(final EsParser.TermvectorsDynamicStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.TERMVECTORS()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.termvectorsStatementBody());
         }
      });
   }

   public Scope visitTermvectorsStatementBody(EsParser.TermvectorsStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermvectorsStatementBodyFields(EsParser.TermvectorsStatementBodyFieldsContext ctx) {
      this.setFieldString(ctx.fieldNames);
      return this.scope;
   }

   public Scope visitMtermvecotrsStatement(final EsParser.MtermvecotrsStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.MTERMVECTORS()).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit(Arrays.asList(ctx.mtermvectorsStatementBody(), ctx.mtermvectorsStatementBody1()));
         }
      });
   }

   public Scope visitMtermvectorsStatementBody(EsParser.MtermvectorsStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMtermvectorsStatementBodyFields(EsParser.MtermvectorsStatementBodyFieldsContext ctx) {
      this.setFieldString(ctx.fieldNames);
      return this.scope;
   }

   public Scope visitMtermvectorsStatementBodyIndex(EsParser.MtermvectorsStatementBodyIndexContext ctx) {
      this.setIndexString(ctx.indexName);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMtermvectorsStatementBody1(EsParser.MtermvectorsStatementBody1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMtermvectorsStatementBody1Fields(EsParser.MtermvectorsStatementBody1FieldsContext ctx) {
      this.setFieldStrings(ctx.stringArr());
      return this.scope;
   }

   public Scope visitCreateEnrichStatement(final EsParser.CreateEnrichStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.ENRICH()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.createEnrichStatementBody());
         }
      });
   }

   public Scope visitCreateEnrichStatementBody(EsParser.CreateEnrichStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCreateEnrichStatementPolicyTypeIndices(EsParser.CreateEnrichStatementPolicyTypeIndicesContext ctx) {
      this.setFieldString(ctx.string());
      this.setFieldString(ctx.stringArr());
      return this.scope;
   }

   public Scope visitCreateEnrichStatementPolicyTypeMatchField(EsParser.CreateEnrichStatementPolicyTypeMatchFieldContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitCreateEnrichStatementPolicyTypeEnrichFields(EsParser.CreateEnrichStatementPolicyTypeEnrichFieldsContext ctx) {
      this.setFieldString(ctx.fieldNames);
      return this.scope;
   }

   public Scope visitDeleteEnrichStatement(final EsParser.DeleteEnrichStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.ENRICH()).path(ctx.POLICY()).path(ctx.myPolicy).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitGetEnrichStatement(final EsParser.GetEnrichStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.ENRICH()).path(ctx.POLICY()).path(ctx.myPolicy).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitExecuteEnrichStatement(final EsParser.ExecuteEnrichStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.ENRICH()).path(ctx.POLICY()).path(ctx.myPolicy).path(ctx.EXECUTE()).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitStatsEnrichStatement(final EsParser.StatsEnrichStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.ENRICH()).path(ctx.STATS1()).fragment(ctx.uriFragments());
         }
      });
   }

   public Scope visitAutoScalingCreateOrUpdateStatement(final EsParser.AutoScalingCreateOrUpdateStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.AUTO_SCALING()).path(ctx.POLICY()).path(ctx.uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitAutoScalingGetStatement(final EsParser.AutoScalingGetStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.AUTO_SCALING()).path(ctx.uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitAutoScalingGetPolicyStatement(final EsParser.AutoScalingGetPolicyStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.AUTO_SCALING()).path(ctx.POLICY()).path(ctx.uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitAutoScalingDeleteStatement(final EsParser.AutoScalingDeleteStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.AUTO_SCALING()).path(ctx.POLICY()).path(ctx.uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitCatStatement(final EsParser.CatStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.CAT()).path(ctx.uriAppendixExpr().uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitClusterStatement(final EsParser.ClusterStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.name).path(ctx.uriAppendixExpr().uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitClusterClusterReplicationStatement(final EsParser.ClusterClusterReplicationStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriSeg()).path(ctx.CCR()).path(ctx.uriAppendixExpr().uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitDataStreamStatement(final EsParser.DataStreamStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.DATA_STREAM()).path(ctx.uriAppendixExpr().uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitFeaturesStatement(final EsParser.FeaturesStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriPrefixExpr().uriSeg()).path(ctx.FEATURES()).path(ctx.uriAppendixExpr().uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitFleetStatement(final EsParser.FleetStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.uriPrefixExpr().uriSeg()).path(ctx.FLEET()).path(ctx.uriAppendixExpr().uriSeg()).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.obj());
         }
      });
   }

   public Scope visitUriPrefixExpr(EsParser.UriPrefixExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUriAppendixExpr(EsParser.UriAppendixExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGraphStatement(final EsParser.GraphStatementContext ctx) {
      return this.scopeVisit(ctx, new Function<RequestWrapper, RequestBuilder>() {
         public RequestBuilder apply(RequestWrapper c) {
            return c.builder.method(ctx.httpMethod).path(ctx.indexName).path(ctx.GRAPH()).path(ctx.other).index(ctx.indexName).fragment(ctx.uriFragments());
         }
      }, new Function<RuleNode, Object>() {
         public Object apply(RuleNode c) {
            return ScopeVisitor.this.visit((ParseTree)ctx.graphStatementBody());
         }
      });
   }

   public Scope visitGraphStatementBody(EsParser.GraphStatementBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGraphStatementConnections(EsParser.GraphStatementConnectionsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGraphStatementVertices(EsParser.GraphStatementVerticesContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGraphStatementVertice(EsParser.GraphStatementVerticeContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGraphStatementVerticeField(EsParser.GraphStatementVerticeFieldContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitGraphStatementVerticeInclude(EsParser.GraphStatementVerticeIncludeContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGraphStatementVerticeExclude(EsParser.GraphStatementVerticeExcludeContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAdjacencyMatrixAgg(EsParser.AdjacencyMatrixAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAdjacencyMatrixAggPart(EsParser.AdjacencyMatrixAggPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAutoDateHistogramAgg(EsParser.AutoDateHistogramAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCategorizeTextAgg(EsParser.CategorizeTextAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitChildrenAgg(EsParser.ChildrenAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCompositeAgg(EsParser.CompositeAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCompositeAggItem(EsParser.CompositeAggItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDateHistogramAgg(EsParser.DateHistogramAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDateRangeAgg(EsParser.DateRangeAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDiversifiedSamplerAgg(EsParser.DiversifiedSamplerAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFilterAgg(EsParser.FilterAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFiltersAgg(EsParser.FiltersAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFiltersAggBody(EsParser.FiltersAggBodyContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoDistanceAgg(EsParser.GeoDistanceAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoHashGridAgg(EsParser.GeoHashGridAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoTileGridAgg(EsParser.GeoTileGridAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitHistogramAgg(EsParser.HistogramAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitIpRangeAgg(EsParser.IpRangeAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMissingAgg(EsParser.MissingAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMultiTermsAgg(EsParser.MultiTermsAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitNestedAgg(EsParser.NestedAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitParentAgg(EsParser.ParentAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRangeAgg(EsParser.RangeAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRangeAggItem(EsParser.RangeAggItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRareTermsAgg(EsParser.RareTermsAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitReverseNestedAgg(EsParser.ReverseNestedAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSamplerAgg(EsParser.SamplerAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSignificantCrimeTypesAgg(EsParser.SignificantCrimeTypesAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSignificantTextAgg(EsParser.SignificantTextAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSignificantTermsAgg(EsParser.SignificantTermsAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAggBackgroundFilter(EsParser.AggBackgroundFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTermsAgg(EsParser.TermsAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitVariableWidthHistogramAgg(EsParser.VariableWidthHistogramAggContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMetricsAggs(EsParser.MetricsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAvgAggs(EsParser.AvgAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBoxplotAggs(EsParser.BoxplotAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCardinalityAggs(EsParser.CardinalityAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitExtendedStatsAggs(EsParser.ExtendedStatsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoBoundsAggs(EsParser.GeoBoundsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoCentroidAggs(EsParser.GeoCentroidAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitGeoLineAggs(EsParser.GeoLineAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMatrixStatsAggs(EsParser.MatrixStatsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMatrixStatsAggsPart(EsParser.MatrixStatsAggsPartContext ctx) {
      return this.scope;
   }

   public Scope visitMaxAggs(EsParser.MaxAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMedianAbsoluteDeviationAggs(EsParser.MedianAbsoluteDeviationAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMinAggs(EsParser.MinAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPercentileRanksAggs(EsParser.PercentileRanksAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPercentilesAggs(EsParser.PercentilesAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRateAggs(EsParser.RateAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitRateAggsItem(EsParser.RateAggsItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitScriptedMetricAggs(EsParser.ScriptedMetricAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitStatsAggs(EsParser.StatsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitStringStatsAggs(EsParser.StringStatsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSumAggs(EsParser.SumAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTTestAggs(EsParser.TTestAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTTestAggsItem(EsParser.TTestAggsItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopHitsAggs(EsParser.TopHitsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopMetricsAggs(EsParser.TopMetricsAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopMetricsAggsItem(EsParser.TopMetricsAggsItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopMetricsAggSort(EsParser.TopMetricsAggSortContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopMetricsAggsMetrics(EsParser.TopMetricsAggsMetricsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopMetricsAggsMetricsItems(EsParser.TopMetricsAggsMetricsItemsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTopMetricsAggsMetricsItem(EsParser.TopMetricsAggsMetricsItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitTypesCountAggs(EsParser.TypesCountAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitWeightedAvgAggs(EsParser.WeightedAvgAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitWeightedAvgAggsItem(EsParser.WeightedAvgAggsItemContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitWeightedAvgAggsItemValue(EsParser.WeightedAvgAggsItemValueContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitWeightedAvgAggsItemWeight(EsParser.WeightedAvgAggsItemWeightContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitValueCountAggs(EsParser.ValueCountAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPipeLineAggs(EsParser.PipeLineAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAverageBucketAggs(EsParser.AverageBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBucketScriptAggs(EsParser.BucketScriptAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBucketCountKsTestAggs(EsParser.BucketCountKsTestAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBucketCorreationAggs(EsParser.BucketCorreationAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBucketSelectorAggs(EsParser.BucketSelectorAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBucketSortAggs(EsParser.BucketSortAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCumulativeCardinalityAggs(EsParser.CumulativeCardinalityAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitCumulativeSumAggs(EsParser.CumulativeSumAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDerivativeAggs(EsParser.DerivativeAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitExtendedStatsBucketAggs(EsParser.ExtendedStatsBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMaxBucketAggs(EsParser.MaxBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMinBucketAggs(EsParser.MinBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMovingAvgAggs(EsParser.MovingAvgAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMovingFnAggs(EsParser.MovingFnAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMovingPercentilesAggs(EsParser.MovingPercentilesAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitNormalizeAggs(EsParser.NormalizeAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPercentilesBucketAggs(EsParser.PercentilesBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSerialDiffAggs(EsParser.SerialDiffAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitStatsBucketAggs(EsParser.StatsBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSumBucketAggs(EsParser.SumBucketAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitInferenceAggs(EsParser.InferenceAggsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitAggCommonPart(EsParser.AggCommonPartContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldFilter(EsParser.FieldFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldSimpleFilter(EsParser.FieldSimpleFilterContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindValueFields(ctx.fieldValue, ctx.fieldName);
      return this.scope;
   }

   public Scope visitFieldExactFilter(EsParser.FieldExactFilterContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindContext(ctx);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldQueryFilter(EsParser.FieldQueryFilterContext ctx) {
      this.bindContext(ctx);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldValueFilter(EsParser.FieldValueFilterContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldsNamesExpr(EsParser.FieldsNamesExprContext ctx) {
      return this.scope;
   }

   public Scope visitQueryExpr(EsParser.QueryExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitValueExpr(EsParser.ValueExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldNameExpr(EsParser.FieldNameExprContext ctx) {
      this.setFieldString(ctx.fieldName);
      return this.scope;
   }

   public Scope visitOperatorExpr(EsParser.OperatorExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitDefaultExpr(EsParser.DefaultExprContext ctx) {
      this.setFieldString(ctx.fieldName);
      return this.scope;
   }

   public Scope visitSourceFieldsExpr(EsParser.SourceFieldsExprContext ctx) {
      return this.scope;
   }

   public Scope visitSortExpr(EsParser.SortExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSortItems(EsParser.SortItemsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitSortItem(EsParser.SortItemContext ctx) {
      this.setFieldString(ctx.string());
      return this.scope;
   }

   public Scope visitSortExprOptions(EsParser.SortExprOptionsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitScriptExpr(EsParser.ScriptExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldLikeExpr(EsParser.FieldLikeExprContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldLikeExprN(EsParser.FieldLikeExprNContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldLikeExpr1(EsParser.FieldLikeExpr1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldLikeExprValue(EsParser.FieldLikeExprValueContext ctx) {
      this.bindContext(ctx);
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldLikeExprValueObj(EsParser.FieldLikeExprValueObjContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldLikeExprValueSimple(EsParser.FieldLikeExprValueSimpleContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldDocuments(EsParser.FieldDocumentsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldDocument(EsParser.FieldDocumentContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldDocumentValue(EsParser.FieldDocumentValueContext ctx) {
      this.setFieldString(ctx.fieldName);
      this.bindContext(ctx);
      return this.scope;
   }

   public Scope visitFieldIndex1(EsParser.FieldIndex1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldId1(EsParser.FieldId1Context ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldIndex(EsParser.FieldIndexContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitFieldId(EsParser.FieldIdContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPairs(EsParser.PairsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUriSeg(EsParser.UriSegContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitString(EsParser.StringContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitObj(EsParser.ObjContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitPair(EsParser.PairContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitStringArr(EsParser.StringArrContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitArr(EsParser.ArrContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitBool(EsParser.BoolContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitJvalue(EsParser.JvalueContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUriFragments(EsParser.UriFragmentsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUriFragmentSegments(EsParser.UriFragmentSegmentsContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitUriFragmentSegment(EsParser.UriFragmentSegmentContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMappingResponse(EsParser.MappingResponseContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visitMappingResponseMapping(EsParser.MappingResponseMappingContext ctx) {
      return (Scope)this.visitChildren(ctx);
   }

   public Scope visit(ParseTree tree) {
      return tree == null ? this.scope : (Scope)super.visit(tree);
   }

   public Scope visit(List trees) {
      if (trees != null && trees.size() != 0) {
         for(Object tree : trees) {
            ((ParseTree)tree).accept(this);
         }

         return this.scope;
      } else {
         return this.scope;
      }
   }

   private void setFieldString(EsParser.StringContext stringContext) {
      this.setFieldString(stringContext, false);
   }

   private void setFieldString(EsParser.StringContext stringContext, boolean supportRegex) {
      if (stringContext != null) {
         stringContext.supportRegex = supportRegex;
         String field = this.getText(stringContext);
         this.scope.addField(field);
         if (!this.fields.contains(stringContext)) {
            this.fields.add(stringContext);
         }

      }
   }

   private void setFieldString(List<EsParser.StringContext> stringContexts) {
      this.setFieldString(stringContexts, false);
   }

   private void setFieldString(List<EsParser.StringContext> stringContexts, boolean supportRegex) {
      if (stringContexts != null && stringContexts.size() != 0) {
         for(EsParser.StringContext stringContext : stringContexts) {
            this.setFieldString(stringContext, supportRegex);
         }

      }
   }

   private void setFieldString(EsParser.StringArrContext stringArrContext) {
      this.setFieldString(stringArrContext, false);
   }

   private void setFieldString(EsParser.StringArrContext stringArrContext, boolean supportRegex) {
      if (stringArrContext != null) {
         List<EsParser.StringContext> strings = stringArrContext.string();
         if (strings != null && strings.size() > 0) {
            for(EsParser.StringContext string : strings) {
               this.setFieldString(string, supportRegex);
            }
         }

      }
   }

   private void setFieldStrings(List<EsParser.StringArrContext> stringArrContexts) {
      this.setFieldStrings(stringArrContexts, false);
   }

   private void setFieldStrings(List<EsParser.StringArrContext> stringArrContexts, boolean supportRegex) {
      if (stringArrContexts != null && stringArrContexts.size() != 0) {
         for(EsParser.StringArrContext stringArrContext : stringArrContexts) {
            this.setFieldString(stringArrContext, supportRegex);
         }

      }
   }

   private void setMappingString(EsParserContextBase stringContext) {
      if (stringContext != null) {
         String mappingName = this.getText(stringContext);
         this.scope.addMapping(mappingName);
         if (!this.mappings.contains(stringContext)) {
            this.mappings.add(stringContext);
         }

      }
   }

   private void setMappingStrings(EsParser.StringArrContext stringArrContext) {
      if (stringArrContext != null) {
         List<EsParser.StringContext> strings = stringArrContext.string();
         if (strings != null && strings.size() > 0) {
            for(EsParser.StringContext string : strings) {
               this.setMappingString(string);
            }
         }

      }
   }

   private void setIndexString(EsParser.StringContext stringContext) {
      if (stringContext != null) {
         String field = this.getText(stringContext);
         this.scope.addIndex(field);
         if (!this.indices.contains(stringContext)) {
            this.indices.add(stringContext);
         }

      }
   }

   private void setIndexStrings(EsParser.StringArrContext stringArrContext) {
      if (stringArrContext != null) {
         List<EsParser.StringContext> strings = stringArrContext.string();
         if (strings != null && strings.size() > 0) {
            for(EsParser.StringContext string : strings) {
               this.setIndexString(string);
            }
         }

      }
   }

   private String getText(EsParserContextBase context) {
      String text = context.getText();
      return text.length() > 0 ? text.substring(1, text.length() - 1) : "";
   }

   private List<EsParserContextBase> combineList(List... all) {
      List<EsParserContextBase> list = new ArrayList();
      if (all != null && all.length != 0) {
         for(List data : all) {
            if (data != null && data.size() != 0) {
               list.addAll(data);
            }
         }

         return list;
      } else {
         return list;
      }
   }

   private void visitObjectRuleContextList(List values) {
      if (values != null && values.size() > 0) {
         for(Object o : values) {
            ParserRuleContext value = (ParserRuleContext)o;
            this.visit((ParseTree)value);
         }
      }

   }

   private void visitObjectRuleContextList(List... valuesList) {
      if (valuesList != null && valuesList.length != 0) {
         List<Object> values = new ArrayList();

         for(Object obj : valuesList) {
            if (obj instanceof List) {
               List<?> list = (List)obj;
               if (list != null && list.size() > 0) {
                  for(Object item : list) {
                     values.add(item);
                  }
               }
            }
         }

         for(int i = 0; i < values.size(); ++i) {
            ParserRuleContext value = (ParserRuleContext)values.get(i);
            this.visit((ParseTree)value);
            if (i != values.size() - 1) {
            }
         }

      }
   }

   private void bindContext(EsParserContextBase ctx, EsParserContextBase... superFields) {
      List<EsParserContextBase> fields = this.getContextFields(ctx);
      if (superFields != null && superFields.length > 0) {
         for(EsParserContextBase superField : superFields) {
            if (!fields.contains(superField)) {
               fields.add(superField);
            }
         }
      }

      List<EsParserContextBase> values = this.getContextValues(ctx);
      this.bindValuesFields(values, fields);
   }

   private void bindValuesFields(List<EsParserContextBase> values, List<EsParserContextBase> fields) {
      if (values != null && values.size() != 0) {
         for(EsParserContextBase value : values) {
            this.bindValueFields(value, fields);
         }

      }
   }

   private void bindValueFields(EsParserContextBase value, EsParserContextBase... fields) {
      if (value != null) {
         this.bindValue(value);
         if (fields != null && fields.length != 0) {
            for(EsParserContextBase field : fields) {
               int index = value.valueBinds.indexOf(field);
               if (index == -1) {
                  value.valueBinds.add(field);
               }
            }

         }
      }
   }

   private void bindValues(List<EsParserContextBase> fields, List<EsParserContextBase> values) {
      if (values != null && values.size() != 0) {
         for(EsParserContextBase value : values) {
            this.bindValue(value);
            if (fields != null && fields.size() > 0) {
               this.bindValueFields(value, fields);
            }
         }

      }
   }

   private void bindValueFields(EsParserContextBase value, List<EsParserContextBase> fields) {
      if (value != null) {
         this.bindValue(value);
         if (fields != null && fields.size() != 0) {
            for(EsParserContextBase field : fields) {
               int index = value.valueBinds.indexOf(field);
               if (index == -1) {
                  value.valueBinds.add(field);
               }
            }

         }
      }
   }

   private void bindValues(List<EsParserContextBase> values) {
      if (values != null && values.size() != 0) {
         for(EsParserContextBase value : values) {
            this.bindValue(value);
         }

      }
   }

   private void bindValue(EsParserContextBase value) {
      int index = this.values.indexOf(value);
      if (index == -1) {
         this.values.add(value);
         value.value = true;
      }

      if (value.valueBinds == null) {
         value.valueBinds = new ArrayList();
      }

   }

   private List<EsParserContextBase> getContextFields(EsParserContextBase... contexts) {
      return this.getContextFeatures(0, contexts);
   }

   private List<EsParserContextBase> getContextValues(EsParserContextBase... contexts) {
      return this.getContextFeatures(1, contexts);
   }

   private List<EsParserContextBase> getContextFields(List<EsParserContextBase>... contexts) {
      return this.getContextFeatures(0, (List[])contexts);
   }

   private List<EsParserContextBase> getContextValues(List<EsParserContextBase>... contexts) {
      return this.getContextFeatures(1, (List[])contexts);
   }

   private List<EsParserContextBase> getContextFeatures(int type, EsParserContextBase... contexts) {
      List<EsParserContextBase> allFields = new ArrayList();
      if (contexts != null && contexts.length != 0) {
         List<EsParserContextBase> feet = new ArrayList();

         for(EsParserContextBase ctx : contexts) {
            this.getContextFieldsInternal(allFields, ctx, feet, type);
         }

         return allFields;
      } else {
         return allFields;
      }
   }

   private List<EsParserContextBase> getContextFeatures(int type, List<EsParserContextBase>... contexts) {
      List<EsParserContextBase> allFields = new ArrayList();
      if (contexts != null && contexts.length != 0) {
         List<EsParserContextBase> feet = new ArrayList();

         for(List<EsParserContextBase> ctxs : contexts) {
            if (ctxs != null && ctxs.size() != 0) {
               for(EsParserContextBase ctx : ctxs) {
                  this.getContextFieldsInternal(allFields, ctx, feet, type);
               }
            }
         }

         return allFields;
      } else {
         return allFields;
      }
   }

   private void getContextFieldsInternal(List<EsParserContextBase> output, EsParserContextBase ctx, List<EsParserContextBase> feet, int type) {
      if (!feet.contains(ctx)) {
         feet.add(ctx);
         if (type == 0) {
            if (ctx.fields != null && ctx.fields.size() > 0) {
               output.addAll(ctx.fields);
            }
         } else if (ctx.values != null && ctx.values.size() > 0) {
            output.addAll(ctx.values);
         }

         if (ctx.children != null && ctx.children.size() > 0) {
            for(ParseTree child : ctx.children) {
               if (child instanceof EsParserContextBase) {
                  Class cls = child.getClass();
                  if (cls != EsParser.StringArrContext.class && cls != EsParser.StringContext.class && cls != EsParser.PairsContext.class && cls != EsParser.JvalueContext.class && cls != EsParser.ObjContext.class && cls != EsParser.ArrContext.class && cls != EsParser.BoolContext.class && cls != EsParser.UriSegContext.class) {
                     this.getContextFieldsInternal(output, (EsParserContextBase)child, feet, type);
                  }
               }
            }
         }

      }
   }

   private <T extends RuleNode> Scope scopeVisit(T ruleNode, Function<RequestWrapper, RequestBuilder> requestHandler, Function<T, Object>... handlers) {
      Scope current = this.enterScope(ruleNode);
      if (requestHandler != null) {
         RequestBuilder builder = RequestBuilder.builder();
         RequestWrapper<T> wrapper = new RequestWrapper<T>();
         wrapper.ctx = ruleNode;
         wrapper.builder = builder;
         requestHandler.apply(wrapper);
         current.request = builder.build();
         Set<String> indices = current.request.getIndices();
         if (indices != null && indices.size() > 0) {
            for(String index : indices) {
               this.scope.addIndex(index);
            }
         }
      }

      if (handlers != null && handlers.length > 0) {
         for(Function<T, Object> handler : handlers) {
            handler.apply(ruleNode);
         }
      }

      this.indices.addAll(current.request.indexRefs);
      this.mappings.addAll(current.request.mappingRefs);
      this.exitScope();
      return this.scope;
   }

   private Scope scopeVisit(RuleNode ruleNode) {
      this.enterScope(ruleNode);
      this.visitChildren(ruleNode);
      this.exitScope();
      return this.scope;
   }

   private Scope enterScope(ParseTree tree) {
      Scope scope = new Scope(tree);
      this.scope = scope;
      this.scope.enterScope(scope);
      return scope;
   }

   private void exitScope() {
      this.scope.exitScope();
   }

   private void visitFields(EsParser.CuDataStatementValueContext ctx, List<String> path, List<EsParser.StringContext> ctxs, List<FieldItem> values) {
      if (ctx != null) {
         EsParser.CuDataStatementObjValueContext objVal = ctx.objVal;
         List<EsParser.CuDataStatementObjValuePairContext> ctxPairs = objVal.cuDataStatementObjValuePair();
         if (ctxPairs != null && ctxPairs.size() > 0) {
            for(EsParser.CuDataStatementObjValuePairContext ctxPair : ctxPairs) {
               EsParser.StringContext fieldName = ctxPair.fieldName;
               if (fieldName != null) {
                  path.add(fieldName.getTextValue());
                  ctxs.add(fieldName);
                  EsParser.CuDataStatementValueContext fieldValue = ctxPair.fieldValue;
                  if (fieldValue != null) {
                     if (fieldValue.objVal != null) {
                        this.visitFields(fieldValue, path, ctxs, values);
                     } else {
                        FieldItem item = new FieldItem();
                        item.name = StringJoin.join(path, ".");
                        item.ctx = fieldName;
                        item.paths = new ArrayList();

                        for(EsParser.StringContext c : ctxs) {
                           item.paths.add(c);
                        }

                        fieldName.putAttribute("complexFields", item.paths);
                        values.add(item);
                        ctxs.remove(path.size() - 1);
                        path.remove(path.size() - 1);
                     }
                  } else {
                     FieldItem item = new FieldItem();
                     item.name = StringJoin.join(path, ".");
                     item.ctx = fieldName;
                     item.paths = new ArrayList();

                     for(EsParser.StringContext c : ctxs) {
                        item.paths.add(c);
                     }

                     fieldName.putAttribute("complexFields", item.paths);
                     values.add(item);
                     ctxs.remove(path.size() - 1);
                     path.remove(path.size() - 1);
                  }
               }
            }
         }

      }
   }

   class RequestWrapper<T extends RuleNode> {
      RequestBuilder builder;
      T ctx;
   }

   static class FieldItem {
      String name;
      EsParser.StringContext ctx;
      List<EsParser.StringContext> paths;
   }
}
