package util.sqlparse.visitor.gauss.visitor;

import com.chenyang.druid.sql.ast.SQLObject;
import com.chenyang.druid.sql.ast.SQLStatement;
import com.chenyang.druid.sql.ast.expr.SQLIdentifierExpr;
import com.chenyang.druid.sql.ast.statement.SQLDeleteStatement;
import com.chenyang.druid.sql.ast.statement.SQLExprTableSource;
import com.chenyang.druid.sql.ast.statement.SQLInsertStatement;
import com.chenyang.druid.sql.ast.statement.SQLJoinTableSource;
import com.chenyang.druid.sql.ast.statement.SQLLateralViewTableSource;
import com.chenyang.druid.sql.ast.statement.SQLRevokeStatement;
import com.chenyang.druid.sql.ast.statement.SQLSelectStatement;
import com.chenyang.druid.sql.ast.statement.SQLSubqueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUnionQuery;
import com.chenyang.druid.sql.ast.statement.SQLUnionQueryTableSource;
import com.chenyang.druid.sql.ast.statement.SQLUpdateStatement;
import com.chenyang.druid.sql.ast.statement.SQLWithSubqueryClause;
import com.chenyang.druid.sql.dialect.gauss.ast.expr.tablesource.GaussExprTableSource;
import com.chenyang.druid.sql.dialect.gauss.ast.expr.tablesource.GaussSubqueryTableSource;
import com.chenyang.druid.sql.dialect.gauss.ast.stmt.GaussDeleteStatement;
import com.chenyang.druid.sql.dialect.gauss.ast.stmt.GaussGrantStatement;
import com.chenyang.druid.sql.dialect.gauss.ast.stmt.GaussInsertStatement;
import com.chenyang.druid.sql.dialect.gauss.ast.stmt.GaussSelectQueryBlock;
import com.chenyang.druid.sql.dialect.gauss.ast.stmt.GaussUpdateStatement;
import com.chenyang.druid.sql.dialect.gauss.visitor.DefaultGaussASTVisitor;
import java.util.List;
import util.sqlparse.visitor.common.scope.Scope;

public abstract class ParseVisitor extends DefaultGaussASTVisitor {
   private boolean debug = false;
   protected Scope scope;

   public ParseVisitor(Scope scope) {
      this.scope = scope;
   }

   public void perform(List<SQLStatement> statements) {
      if (statements != null && statements.size() != 0) {
         for(SQLStatement statement : statements) {
            statement.accept(this);
         }

         this.scope.reset();
      }
   }

   public boolean visit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("enter SQLSelectStatement" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLSelectStatement x) {
      if (this.debug) {
         System.out.println("exit SQLSelectStatement" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLInsertStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(GaussInsertStatement x) {
      return this.visit((SQLInsertStatement)x);
   }

   public void endVisit(GaussInsertStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLUpdateStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(GaussUpdateStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(GaussUpdateStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLDeleteStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(GaussDeleteStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(GaussDeleteStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(GaussGrantStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(GaussGrantStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLRevokeStatement x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLRevokeStatement x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("enter SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLWithSubqueryClause.Entry x) {
      if (this.debug) {
         System.out.println("exit SQLWithSubqueryClause.Entry" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(GaussSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("enter GaussSelectQueryBlock " + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(GaussSelectQueryBlock x) {
      if (this.debug) {
         System.out.println("exit GaussSelectQueryBlock " + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLUnionQuery x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUnionQuery x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLLateralViewTableSource x) {
      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLLateralViewTableSource x) {
      this.scope.exitScope();
   }

   public boolean visit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLSubqueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLSubqueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(GaussSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("enter GaussSubqueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(GaussSubqueryTableSource x) {
      if (this.debug) {
         System.out.println("exit GaussSubqueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public boolean visit(SQLJoinTableSource x) {
      return true;
   }

   public boolean visit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("enter SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.enterScope((SQLObject)x);
      return true;
   }

   public void endVisit(SQLUnionQueryTableSource x) {
      if (this.debug) {
         System.out.println("exit SQLUnionQueryTableSource" + x.toString());
      }

      this.scope.exitScope();
   }

   public void endVisit(SQLJoinTableSource x) {
   }

   public boolean visit(SQLExprTableSource x) {
      return true;
   }

   public void endVisit(SQLExprTableSource x) {
   }

   public boolean visit(GaussExprTableSource x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr)) {
         if (this.debug) {
            System.out.println("enter GaussExprTableSource  " + x);
         }

         this.scope.enterScope((SQLObject)x);
      } else if (this.debug) {
         System.out.println("begin GaussExprTableSource" + x.toString());
      }

      return true;
   }

   public void endVisit(GaussExprTableSource x) {
      if (!(x.getExpr() instanceof SQLIdentifierExpr)) {
         if (this.debug) {
            System.out.println("exit GaussExprTableSource  " + x);
         }

         this.scope.exitScope();
      } else if (this.debug) {
         System.out.println("end GaussExprTableSource" + x.toString());
      }

   }

   protected void acceptChild(List<? extends SQLObject> children) {
      if (children != null && children.size() != 0) {
         for(SQLObject child : children) {
            child.accept(this);
         }

      }
   }

   protected void visitChild(SQLObject x) {
      if (x != null) {
         x.accept(this);
      }
   }

   protected void visitChild(List<? extends SQLObject> x) {
      if (x != null && x.size() != 0) {
         for(SQLObject sqlObject : x) {
            this.visitChild(sqlObject);
         }

      }
   }

   protected boolean isEqual(String name1, String name2) {
      return this.scope.dialector.isEqual(name1, name2);
   }
}
